/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.osgi.resource.ArtifactDescriptorRepositoryContentCapability;
import org.eclipse.tycho.osgi.resource.InstallableUnitCapability;
import org.eclipse.tycho.osgi.resource.InstallableUnitRequirement;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class InstallableUnitResource
implements Resource {
    IInstallableUnit installableUnit;
    private final Map<String, List<Requirement>> requirementsMap;
    private final Map<String, List<Capability>> capabilitiesMap;

    public InstallableUnitResource(IInstallableUnit installableUnit, IArtifactRepository artifactRepository) {
        Object cap;
        this.installableUnit = installableUnit;
        Collection requirements = installableUnit.getRequirements();
        this.requirementsMap = new HashMap<String, List<Requirement>>(requirements.size());
        for (IRequirement requirement : requirements) {
            if (!RequiredCapability.isVersionRangeRequirement((IMatchExpression)requirement.getMatches())) continue;
            InstallableUnitRequirement req = new InstallableUnitRequirement(this, requirement);
            this.requirementsMap.computeIfAbsent(req.getNamespace(), nil -> new ArrayList()).add(req);
        }
        List artifacts = installableUnit.getArtifacts().stream().flatMap(key -> {
            IArtifactDescriptor[] descriptors = artifactRepository.getArtifactDescriptors(key);
            return Arrays.stream(descriptors);
        }).toList();
        Collection capabilities = installableUnit.getProvidedCapabilities();
        this.capabilitiesMap = new HashMap<String, List<Capability>>(capabilities.size() + artifacts.size() + 1);
        for (IProvidedCapability capability : capabilities) {
            cap = new InstallableUnitCapability(this, capability);
            this.capabilitiesMap.computeIfAbsent(((InstallableUnitCapability)cap).getNamespace(), nil -> new ArrayList()).add(cap);
        }
        for (IArtifactDescriptor descriptor : artifacts) {
            cap = new ArtifactDescriptorRepositoryContentCapability(this, descriptor, artifactRepository);
            this.capabilitiesMap.computeIfAbsent(((ArtifactDescriptorRepositoryContentCapability)cap).getNamespace(), nil -> new ArrayList()).add(cap);
        }
    }

    public List<Capability> getCapabilities(String namespace) {
        if (namespace != null) {
            return Collections.unmodifiableList(this.capabilitiesMap.getOrDefault(namespace, List.of()));
        }
        return this.capabilitiesMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Requirement> getRequirements(String namespace) {
        if (namespace != null) {
            return Collections.unmodifiableList(this.requirementsMap.getOrDefault(namespace, List.of()));
        }
        return this.requirementsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String toString() {
        return this.installableUnit.toString();
    }
}

