/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.publisher;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.tycho.p2maven.actions.AbstractDependenciesAction;
import org.osgi.framework.Version;

public class FeatureDependenciesAction
extends AbstractDependenciesAction {
    public static final String INCLUDED_IUS = "org.eclipse.tycho.p2.includedIUs";
    private final Feature feature;

    public FeatureDependenciesAction(Feature feature) {
        this.feature = feature;
    }

    private String getInstallableUnitId(FeatureEntry entry) {
        if (entry.isPlugin()) {
            return entry.getId();
        }
        return entry.getId() + ".feature.group";
    }

    private VersionRange getVersionRange(FeatureEntry entry) {
        String versionSpec = entry.getVersion();
        if (versionSpec == null) {
            return VersionRange.emptyRange;
        }
        String match = entry.getMatch();
        if ("versionRange".equals(match)) {
            return new VersionRange(versionSpec);
        }
        org.eclipse.equinox.p2.metadata.Version version = org.eclipse.equinox.p2.metadata.Version.parseVersion((String)versionSpec);
        if (version.equals(org.eclipse.equinox.p2.metadata.Version.emptyVersion)) {
            return VersionRange.emptyRange;
        }
        if (!entry.isRequires()) {
            return new VersionRange(version, true, version, true);
        }
        if (match == null) {
            return null;
        }
        if (match.equals("perfect")) {
            return new VersionRange(version, true, version, true);
        }
        Version osgiVersion = PublisherHelper.toOSGiVersion((org.eclipse.equinox.p2.metadata.Version)version);
        if (match.equals("equivalent")) {
            org.eclipse.equinox.p2.metadata.Version upper = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)osgiVersion.getMajor(), (int)(osgiVersion.getMinor() + 1), (int)0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("compatible")) {
            org.eclipse.equinox.p2.metadata.Version upper = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)(osgiVersion.getMajor() + 1), (int)0, (int)0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("greaterOrEqual")) {
            return new VersionRange(version, true, new VersionRange(null).getMaximum(), true);
        }
        return null;
    }

    protected Set<IRequirement> getRequiredCapabilities() {
        LinkedHashSet<IRequirement> required = new LinkedHashSet<IRequirement>();
        if (this.feature.getLicenseFeature() != null) {
            String id = this.feature.getLicenseFeature() + ".feature.group";
            VersionRange range = this.getVersionRange(this.createVersion(this.feature.getLicenseFeatureVersion()));
            required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, null, (boolean)false, (boolean)false));
        }
        for (FeatureEntry entry : this.feature.getEntries()) {
            if (entry.isPatch()) continue;
            VersionRange range = entry.isRequires() ? this.getVersionRange(entry) : this.getVersionRange(this.createVersion(entry.getVersion()));
            String id = this.getInstallableUnitId(entry);
            boolean optional = entry.isOptional();
            required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, this.createFilter(entry), (boolean)optional, (boolean)false));
        }
        return required;
    }

    protected org.eclipse.equinox.p2.metadata.Version getVersion() {
        return org.eclipse.equinox.p2.metadata.Version.create((String)this.feature.getVersion());
    }

    protected String getId() {
        return this.feature.getId() + ".feature.group";
    }

    protected void addProvidedCapabilities(Set<IProvidedCapability> provided) {
        provided.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.update.feature", (String)this.feature.getId(), (org.eclipse.equinox.p2.metadata.Version)this.getVersion()));
    }

    protected void addProperties(MetadataFactory.InstallableUnitDescription iud) {
        iud.setProperty("org.eclipse.equinox.p2.type.group", "true");
        StringJoiner includedIUs = new StringJoiner(",");
        for (FeatureEntry entry : this.feature.getEntries()) {
            String id = this.getInstallableUnitId(entry);
            includedIUs.add(id);
        }
        iud.setProperty(INCLUDED_IUS, includedIUs.toString());
    }

    protected void addPublisherAdvice(IPublisherInfo publisherInfo) {
        Path location = new Path(this.feature.getLocation());
        org.eclipse.equinox.p2.metadata.Version version = org.eclipse.equinox.p2.metadata.Version.parseVersion((String)this.feature.getVersion());
        String groupId = this.getId();
        AdviceFileAdvice advice = new AdviceFileAdvice(groupId, version, (IPath)location, (IPath)new Path("p2.inf"));
        if (advice.containsAdvice()) {
            publisherInfo.addAdvice((IPublisherAdvice)advice);
        }
    }

    private IMatchExpression<IInstallableUnit> createFilter(FeatureEntry entry) {
        StringBuilder result = new StringBuilder();
        if (entry.getFilter() != null) {
            result.append(entry.getFilter());
        }
        this.expandFilter(entry.getOS(), "osgi.os", result);
        this.expandFilter(entry.getWS(), "osgi.ws", result);
        this.expandFilter(entry.getArch(), "osgi.arch", result);
        this.expandFilter(entry.getNL(), "osgi.nl", result);
        if (result.length() != 0) {
            if (this.getFilterCount(entry) > 1) {
                result.insert(0, "(&").append(')');
            }
            return InstallableUnit.parseFilter((String)result.toString());
        }
        return null;
    }

    private int getFilterCount(FeatureEntry entry) {
        int filterCount = 0;
        if (entry.getOS() != null && !entry.getOS().isEmpty()) {
            ++filterCount;
        }
        if (entry.getWS() != null && !entry.getWS().isEmpty()) {
            ++filterCount;
        }
        if (entry.getArch() != null && !entry.getArch().isEmpty()) {
            ++filterCount;
        }
        if (entry.getNL() != null && !entry.getNL().isEmpty()) {
            ++filterCount;
        }
        if (entry.getFilter() != null && !entry.getFilter().isEmpty()) {
            ++filterCount;
        }
        return filterCount;
    }

    private void expandFilter(String filter, String osgiFilterValue, StringBuilder result) {
        if (filter != null && !filter.isEmpty()) {
            StringTokenizer token = new StringTokenizer(filter, ",");
            if (token.countTokens() == 1) {
                result.append("(" + osgiFilterValue + "=" + filter + ")");
            } else {
                result.append("(|");
                while (token.hasMoreElements()) {
                    result.append("(" + osgiFilterValue + "=" + token.nextToken() + ")");
                }
                result.append(')');
            }
        }
    }

    public static Set<String> getIncludedUIs(IInstallableUnit iu) {
        LinkedHashSet<String> includedIUs = new LinkedHashSet<String>();
        String prop = iu.getProperty(INCLUDED_IUS);
        if (prop != null) {
            StringTokenizer st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                includedIUs.add(st.nextToken());
            }
        }
        return includedIUs;
    }
}

