/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.tycho.IArtifactSink;
import org.eclipse.tycho.IRawArtifactSink;
import org.eclipse.tycho.p2.repository.ArtifactTransferPolicy;

public final class ArtifactProviderImplUtilities {
    public static void canWriteToSink(IArtifactSink sink) {
        if (!sink.canBeginWrite()) {
            throw new IllegalArgumentException("Cannot write to artifact sink. Has the sink already been used for a different read operation?");
        }
    }

    public static void canWriteCanonicalArtifactToSink(IArtifactSink artifactSink) throws IllegalArgumentException {
        IRawArtifactSink rawSink;
        if (artifactSink instanceof IRawArtifactSink && !ArtifactTransferPolicy.isCanonicalFormat((rawSink = (IRawArtifactSink)artifactSink).getArtifactFormatToBeWritten())) {
            throw new IllegalArgumentException("Artifact should not be written in canonical format to a sink expecting a non-canonical format. Did you mean to call getRawArtifact?");
        }
    }

    public static MultiStatus createMultiStatusWithFixedSeverity(int severity, String pluginId, List<IStatus> children, String message) {
        return new FixedSeverityMultiStatus(severity, pluginId, children, message);
    }

    private static class FixedSeverityMultiStatus
    extends MultiStatus {
        public FixedSeverityMultiStatus(int severity, String pluginId, List<IStatus> children, String message) {
            super(pluginId, 0, children.toArray(new IStatus[children.size()]), message, null);
            this.setSeverity(severity);
        }
    }
}

