/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;

public interface ArtifactRepositorySupplier
extends Supplier<Collection<IArtifactRepository>> {
    default public Collection<URI> getRepositoryURLs() {
        return Collections.emptySet();
    }

    public static ArtifactRepositorySupplier composite(final ArtifactRepositorySupplier ... suppliers) {
        return new ArtifactRepositorySupplier(){

            @Override
            public Collection<IArtifactRepository> get() {
                ArrayList<IArtifactRepository> list = new ArrayList<IArtifactRepository>();
                for (ArtifactRepositorySupplier supplier : suppliers) {
                    list.addAll((Collection)supplier.get());
                }
                return list;
            }

            @Override
            public Collection<URI> getRepositoryURLs() {
                ArrayList<URI> list = new ArrayList<URI>();
                for (ArtifactRepositorySupplier supplier : suppliers) {
                    list.addAll(supplier.getRepositoryURLs());
                }
                return list;
            }
        };
    }
}

