/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

public class FileBasedTychoRepositoryIndex
implements TychoRepositoryIndex {
    public static final String ARTIFACTS_INDEX_RELPATH = ".meta/p2-artifacts.properties";
    public static final String METADATA_INDEX_RELPATH = ".meta/p2-local-metadata.properties";
    private static final String EOL = "\n";
    private final File indexFile;
    private final MavenLogger logger;
    private final FileLockService fileLockService;
    private Set<GAV> addedGavs = new HashSet<GAV>();
    private Set<GAV> removedGavs = new HashSet<GAV>();
    private Set<GAV> gavs = new HashSet<GAV>();
    private MavenContext mavenContext;

    private FileBasedTychoRepositoryIndex(File indexFile, FileLockService fileLockService, MavenContext mavenContext) {
        this.indexFile = indexFile;
        this.mavenContext = mavenContext;
        this.fileLockService = fileLockService;
        this.logger = mavenContext.getLogger();
        if (indexFile.isFile()) {
            try (Closeable locked = fileLockService.lock(indexFile);){
                this.gavs = this.read(new FileInputStream(indexFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public MavenContext getMavenContext() {
        return this.mavenContext;
    }

    @Override
    public synchronized Set<GAV> getProjectGAVs() {
        return Collections.unmodifiableSet(new LinkedHashSet<GAV>(this.gavs));
    }

    @Override
    public synchronized void addGav(GAV gav) {
        this.gavs.add(gav);
        this.addedGavs.add(gav);
        if (this.removedGavs.contains(gav)) {
            this.removedGavs.remove(gav);
        }
    }

    @Override
    public synchronized void removeGav(GAV gav) {
        this.gavs.remove(gav);
        this.removedGavs.add(gav);
        if (this.addedGavs.contains(gav)) {
            this.addedGavs.remove(gav);
        }
    }

    @Override
    public synchronized void save() throws IOException {
        if (this.addedGavs.isEmpty() && this.removedGavs.isEmpty() && this.indexFile.isFile()) {
            return;
        }
        File parentDir = this.indexFile.getParentFile();
        if (!parentDir.isDirectory()) {
            parentDir.mkdirs();
        }
        try (Closeable locked = this.fileLockService.lock(this.indexFile);){
            this.reconcile();
            File tempFile = File.createTempFile("index", "tmp", this.indexFile.getParentFile());
            this.write(new FileOutputStream(tempFile));
            if (this.indexFile.isFile()) {
                this.indexFile.delete();
            }
            tempFile.renameTo(this.indexFile);
        }
    }

    private synchronized void reconcile() throws IOException {
        if (this.indexFile.isFile()) {
            this.gavs = this.read(new FileInputStream(this.indexFile));
            for (GAV addedGav : this.addedGavs) {
                this.addGav(addedGav);
            }
            for (GAV removedGav : this.removedGavs) {
                this.removeGav(removedGav);
            }
        }
        this.addedGavs.clear();
        this.removedGavs.clear();
    }

    private void write(OutputStream outStream) throws IOException {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outStream), StandardCharsets.UTF_8);){
            for (GAV gav : this.getProjectGAVs()) {
                out.write(gav.toExternalForm());
                out.write(EOL);
            }
            ((Writer)out).flush();
        }
    }

    private Set<GAV> read(InputStream inStream) throws IOException {
        LinkedHashSet<GAV> result = new LinkedHashSet<GAV>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                try {
                    GAV parsedGAV = GAV.parse(line);
                    result.add(parsedGAV);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("Ignoring invalid line '" + line + "' in " + this.indexFile);
                }
            }
        }
        return result;
    }

    public static TychoRepositoryIndex createMetadataIndex(File basedir, FileLockService fileLockService, MavenContext context) {
        return new FileBasedTychoRepositoryIndex(new File(basedir, METADATA_INDEX_RELPATH), fileLockService, context);
    }

    public static TychoRepositoryIndex createArtifactsIndex(File basedir, FileLockService fileLockService, MavenContext context) {
        return new FileBasedTychoRepositoryIndex(new File(basedir, ARTIFACTS_INDEX_RELPATH), fileLockService, context);
    }
}

