/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.util.Objects;

public class GAV {
    private String groupId;
    private String artifactId;
    private String version;

    public GAV(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        GAV other;
        return o instanceof GAV && Objects.equals(this.groupId, (other = (GAV)o).getGroupId()) && Objects.equals(this.artifactId, other.getArtifactId()) && Objects.equals(this.version, other.getVersion());
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    public String toExternalForm() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
        return sb.toString();
    }

    public static GAV parse(String line) throws IllegalArgumentException {
        int currentIndex = 0;
        int colonIndex = -1;
        colonIndex = GAV.nextColonIndex(line, currentIndex);
        String groupId = GAV.substring(line, currentIndex, colonIndex);
        currentIndex = colonIndex + 1;
        colonIndex = GAV.nextColonIndex(line, currentIndex);
        String artifactId = GAV.substring(line, currentIndex, colonIndex);
        currentIndex = colonIndex + 1;
        String version = GAV.substring(line, currentIndex, line.length());
        return new GAV(groupId, artifactId, version);
    }

    private static String substring(String str, int start, int end) {
        String substring = str.substring(start, end);
        return "".equals(substring) ? null : substring;
    }

    private static int nextColonIndex(String line, int pos) throws IllegalArgumentException {
        int colonIndex = line.indexOf(58, pos);
        if (colonIndex < 0) {
            throw new IllegalArgumentException("Invalid line: '" + line + "'");
        }
        return colonIndex;
    }

    public String toString() {
        return this.toExternalForm();
    }
}

