/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.core.resolver.target.FileArtifactRepository;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.osgi.framework.BundleException;

public class BundlePublisher
extends BundlesAction {
    private BundlePublisher(BundleDescription bundleDescription) {
        super(new BundleDescription[]{bundleDescription});
    }

    public static Optional<IInstallableUnit> getBundleIU(File bundleLocation, IPublisherAdvice ... advices) throws IOException, BundleException {
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)bundleLocation);
        if (bundleDescription == null) {
            return Optional.empty();
        }
        PublisherInfo publisherInfo = new PublisherInfo();
        for (IPublisherAdvice advice : advices) {
            publisherInfo.addAdvice(advice);
        }
        publisherInfo.setArtifactOptions(1);
        String symbolicName = bundleDescription.getSymbolicName();
        if (symbolicName == null) {
            return Optional.empty();
        }
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)symbolicName, (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = FileArtifactRepository.forFile(bundleLocation, key);
        return Optional.ofNullable(BundlePublisher.publishBundle(bundleDescription, descriptor, publisherInfo));
    }

    public static IInstallableUnit publishBundle(BundleDescription bundleDescription, IArtifactDescriptor descriptor, PublisherInfo publisherInfo) {
        BundlePublisher bundlesAction = new BundlePublisher(bundleDescription);
        bundlesAction.setPublisherInfo((IPublisherInfo)publisherInfo);
        IInstallableUnit iu = bundlesAction.doCreateBundleIU(bundleDescription, descriptor.getArtifactKey(), (IPublisherInfo)publisherInfo);
        Collection advice = publisherInfo.getAdvice(null, false, iu.getId(), iu.getVersion(), IPropertyAdvice.class);
        for (IPropertyAdvice entry : advice) {
            Map props = entry.getArtifactProperties(iu, descriptor);
            if (props == null || !(descriptor instanceof SimpleArtifactDescriptor)) continue;
            SimpleArtifactDescriptor simpleArtifactDescriptor = (SimpleArtifactDescriptor)descriptor;
            for (Map.Entry pe : props.entrySet()) {
                simpleArtifactDescriptor.setRepositoryProperty((String)pe.getKey(), (String)pe.getValue());
            }
        }
        return iu;
    }

    public static void createBundleRepository(File repositoryLocation, String name, File[] files, IProgressMonitor monitor) throws ProvisionException {
        if (repositoryLocation.exists()) {
            FileUtils.deleteQuietly((File)repositoryLocation);
        }
        SimpleMetadataRepositoryFactory metadataRepositoryFactory = new SimpleMetadataRepositoryFactory();
        SimpleArtifactRepositoryFactory artifactRepositoryFactory = new SimpleArtifactRepositoryFactory();
        IArtifactRepository artifactRepository = artifactRepositoryFactory.create(repositoryLocation.toURI(), name, null, Map.of());
        IMetadataRepository metadataRepository = metadataRepositoryFactory.create(repositoryLocation.toURI(), name, null, Map.of());
        metadataRepository.executeBatch(m1 -> artifactRepository.executeBatch(m2 -> {
            PublisherInfo publisherInfo = new PublisherInfo();
            publisherInfo.setArtifactOptions(3);
            publisherInfo.setArtifactRepository(artifactRepository);
            publisherInfo.setMetadataRepository(metadataRepository);
            Publisher publisher = new Publisher((IPublisherInfo)publisherInfo);
            publisher.publish(new IPublisherAction[]{new BundlesAction(files)}, m2);
        }, m1), monitor);
    }
}

