/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2maven.InstallableUnitGenerator;

@Component(role=P2DependencyTreeGenerator.class)
public final class P2DependencyTreeGenerator {
    private final InstallableUnitGenerator generator;
    private final TychoProjectManager projectManager;
    private final LegacySupport legacySupport;

    @Inject
    public P2DependencyTreeGenerator(InstallableUnitGenerator generator, TychoProjectManager projectManager, LegacySupport legacySupport) {
        this.generator = generator;
        this.projectManager = projectManager;
        this.legacySupport = legacySupport;
    }

    public List<DependencyTreeNode> buildDependencyTree(MavenProject project, Set<IInstallableUnit> unmapped) throws CoreException {
        Optional<TychoProject> tychoProject = this.projectManager.getTychoProject(project);
        if (tychoProject.isEmpty()) {
            return Collections.emptyList();
        }
        List artifacts = tychoProject.get().getDependencyArtifacts(DefaultReactorProject.adapt(project)).getArtifacts();
        Set units = artifacts.stream().flatMap(d -> d.getInstallableUnits().stream()).collect(Collectors.toCollection(HashSet::new));
        List<IInstallableUnit> initial = List.copyOf(this.generator.getInstallableUnits(project, this.legacySupport.getSession(), false));
        units.removeAll(initial);
        return Collections.unmodifiableList(DependencyTreeNode.create(initial, units, unmapped));
    }

    public static class DependencyTreeNode {
        public static final Comparator<IInstallableUnit> COMPARATOR = Comparator.comparing(IVersionedId::getId, String.CASE_INSENSITIVE_ORDER);
        private final IInstallableUnit iu;
        private final IRequirement satisfies;
        private final List<DependencyTreeNode> children = new ArrayList<DependencyTreeNode>();

        private DependencyTreeNode(IInstallableUnit iu, IRequirement satisfies) {
            this.iu = iu;
            this.satisfies = satisfies;
        }

        public IInstallableUnit getInstallableUnit() {
            return this.iu;
        }

        public IRequirement getRequirement() {
            return this.satisfies;
        }

        public List<DependencyTreeNode> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public String toString() {
            return Objects.toString(this.iu);
        }

        private static List<DependencyTreeNode> create(List<IInstallableUnit> initial, Set<IInstallableUnit> units, Set<IInstallableUnit> unmapped) {
            ArrayList<DependencyTreeNode> rootNodes = new ArrayList<DependencyTreeNode>();
            for (int i = 0; i < initial.size(); ++i) {
                DependencyTreeNode rootNode = new DependencyTreeNode(initial.get(i), null);
                DependencyTreeNode.create(rootNode, units);
                rootNodes.add(rootNode);
            }
            unmapped.addAll(units);
            return rootNodes;
        }

        private static void create(DependencyTreeNode node, Set<IInstallableUnit> units) {
            ArrayList collected = new ArrayList();
            HashMap requirementsMap = new HashMap();
            IInstallableUnit unit = node.getInstallableUnit();
            Stream.concat(unit.getRequirements().stream(), unit.getMetaRequirements().stream()).forEach(requirement -> {
                Iterator iterator = units.iterator();
                while (iterator.hasNext()) {
                    IInstallableUnit other = (IInstallableUnit)iterator.next();
                    if (!other.satisfies(requirement)) continue;
                    collected.add(other);
                    requirementsMap.put(other, requirement);
                    iterator.remove();
                }
            });
            Collections.sort(collected, COMPARATOR);
            for (IInstallableUnit iu : collected) {
                IRequirement satisfies = (IRequirement)requirementsMap.get(iu);
                DependencyTreeNode childNode = new DependencyTreeNode(iu, satisfies);
                node.children.add(childNode);
                DependencyTreeNode.create(childNode, units);
            }
        }
    }
}

