/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.MavenBundleResolver;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.repository.LocalArtifactRepository;
import org.eclipse.tycho.p2.repository.LocalMetadataRepository;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.repository.LocalRepositoryReader;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.eclipse.tycho.p2resolver.TargetDefinitionResolverService;
import org.eclipse.tycho.p2resolver.TargetPlatformFactoryImpl;

@Component(role=TargetPlatformFactory.class)
public class DefaultTargetPlatformFactory
implements TargetPlatformFactory {
    private LocalMetadataRepository localMetadataRepository;
    private LocalArtifactRepository localArtifactRepository;
    @Requirement
    private IProvisioningAgent agent;
    @Requirement
    private MavenContext mavenContext;
    @Requirement
    private LocalRepositoryP2Indices localRepoIndices;
    @Requirement
    private IRepositoryIdManager repositoryIdManager;
    @Requirement
    private MavenBundleResolver bundleResolver;
    @Requirement
    private TychoProjectManager projectManager;
    @Requirement
    private TargetDefinitionResolverService targetDefinitionResolverService;
    private TargetPlatformFactoryImpl impl;

    @Override
    public TargetPlatform createTargetPlatform(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentConfiguration eeConfiguration, List<ReactorProject> reactorProjects, ReactorProject project) {
        return this.getImpl().createTargetPlatform(tpConfiguration, eeConfiguration, reactorProjects, project);
    }

    @Override
    public TargetPlatform createTargetPlatformWithUpdatedReactorContent(TargetPlatform baseTargetPlatform, List<?> upstreamProjectResults, PomDependencyCollector pomDependencies) {
        return this.getImpl().createTargetPlatformWithUpdatedReactorContent(baseTargetPlatform, upstreamProjectResults, pomDependencies);
    }

    private TargetPlatformFactory getImpl() {
        if (this.impl == null) {
            LocalMetadataRepository localMetadataRepo = this.getLocalMetadataRepository(this.mavenContext, this.localRepoIndices);
            LocalArtifactRepository localArtifactRepo = this.getLocalArtifactRepository(this.mavenContext, this.localRepoIndices);
            this.impl = new TargetPlatformFactoryImpl(this.mavenContext, this.agent, localArtifactRepo, localMetadataRepo, this.targetDefinitionResolverService, this.repositoryIdManager, this.projectManager, this.bundleResolver);
        }
        return this.impl;
    }

    private synchronized LocalMetadataRepository getLocalMetadataRepository(MavenContext context, LocalRepositoryP2Indices localRepoIndices) {
        if (this.localMetadataRepository == null) {
            File localMavenRepoRoot = context.getLocalRepositoryRoot();
            LocalRepositoryReader contentLocator = new LocalRepositoryReader(context);
            this.localMetadataRepository = new LocalMetadataRepository(this.getAgent(), localMavenRepoRoot.toURI(), localRepoIndices.getMetadataIndex(), contentLocator);
        }
        return this.localMetadataRepository;
    }

    private synchronized LocalArtifactRepository getLocalArtifactRepository(MavenContext mavenContext, LocalRepositoryP2Indices localRepoIndices) {
        if (this.localArtifactRepository == null) {
            LocalRepositoryReader contentLocator = new LocalRepositoryReader(mavenContext);
            this.localArtifactRepository = new LocalArtifactRepository(this.getAgent(), localRepoIndices, contentLocator);
        }
        return this.localArtifactRepository;
    }

    private IProvisioningAgent getAgent() {
        this.agent.getService(IArtifactRepositoryManager.class);
        return this.agent;
    }
}

