/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.shared.DuplicateFilteringLoggingProgressMonitor;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.resolver.ResolverException;
import org.eclipse.tycho.p2resolver.AbstractResolutionStrategy;
import org.eclipse.tycho.p2resolver.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2resolver.ResolutionData;
import org.eclipse.tycho.p2resolver.ResolutionDataImpl;
import org.eclipse.tycho.p2resolver.SlicerResolutionStrategy;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionResolutionException;
import org.eclipse.tycho.targetplatform.TargetDefinitionSyntaxException;

public class InstallableUnitResolver {
    private static final String SOURCE_IU_ID = "org.eclipse.tycho.internal.target.source.bundles";
    private TargetDefinition.IncludeMode includeMode = null;
    private Boolean includeAllEnvironments = null;
    private Boolean includeSource = null;
    private List<TargetEnvironment> environments;
    private ExecutionEnvironmentResolutionHints executionEnvironment;
    private MavenLogger logger;
    private List<RootUnits> rootUnits = new ArrayList<RootUnits>();
    private IncludeSourceMode sourceMode;

    public InstallableUnitResolver(List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints executionEnvironment, IncludeSourceMode sourceMode, MavenLogger logger) {
        this.environments = environments;
        this.executionEnvironment = executionEnvironment;
        this.sourceMode = sourceMode;
        this.logger = logger;
    }

    public Collection<IInstallableUnit> addLocation(TargetDefinition.InstallableUnitLocation iuLocationDefinition, IQueryable<IInstallableUnit> localUnits) {
        this.setIncludeMode(iuLocationDefinition.getIncludeMode());
        this.setIncludeAllEnvironments(iuLocationDefinition.includeAllEnvironments());
        this.setIncludeSource(switch (this.sourceMode) {
            case IncludeSourceMode.force -> true;
            case IncludeSourceMode.ignore -> false;
            default -> iuLocationDefinition.includeSource();
        });
        Collection<IInstallableUnit> rootIUs = InstallableUnitResolver.getRootIUs(iuLocationDefinition.getUnits(), localUnits);
        this.rootUnits.add(new RootUnits(rootIUs, localUnits));
        return rootIUs;
    }

    private void setIncludeMode(TargetDefinition.IncludeMode newValue) throws TargetDefinitionResolutionException {
        if (this.includeMode != newValue) {
            if (this.includeMode != null) {
                throw new TargetDefinitionResolutionException("Include mode must be the same for all locations");
            }
            this.includeMode = newValue;
        }
    }

    private void setIncludeAllEnvironments(Boolean newValue) throws TargetDefinitionResolutionException {
        if (!newValue.equals(this.includeAllEnvironments)) {
            if (this.includeAllEnvironments != null) {
                throw new TargetDefinitionResolutionException("The attribute 'includeAllPlatforms' must be the same for all locations");
            }
            this.includeAllEnvironments = newValue;
        }
    }

    private void setIncludeSource(Boolean newValue) {
        if (!newValue.equals(this.includeSource)) {
            if (this.includeSource != null) {
                throw new TargetDefinitionResolutionException("The attribute 'includeSource' must be the same for all locations");
            }
            this.includeSource = newValue;
        }
    }

    public IQueryResult<IInstallableUnit> resolve(IQueryable<IInstallableUnit> allUnits) throws ResolverException {
        UnitCollector collector;
        block2: {
            block3: {
                collector = new UnitCollector();
                if (!this.haveContent()) break block2;
                if (this.includeMode != TargetDefinition.IncludeMode.PLANNER) break block3;
                HashSet<IInstallableUnit> allRoots = new HashSet<IInstallableUnit>();
                for (RootUnits root : this.rootUnits) {
                    allRoots.addAll(root.rootIUs);
                }
                ResolutionDataImpl data = new ResolutionDataImpl(this.executionEnvironment);
                data.setRootIUs(allRoots);
                data.setAvailableIUsAndFilter(allUnits);
                Collection<IInstallableUnit> resolve = this.getPlannerResolutionStrategy(data).multiPlatformResolve(this.environments, new DuplicateFilteringLoggingProgressMonitor(this.logger));
                if (resolve.isEmpty()) break block2;
                collector.addAll(resolve);
                if (!this.includeSource.booleanValue()) break block2;
                collector.addAll(InstallableUnitResolver.addSourceBundleUnits(data, this::getPlannerResolutionStrategy, resolve, new DuplicateFilteringLoggingProgressMonitor(this.logger)));
                break block2;
            }
            for (RootUnits root : this.rootUnits) {
                ResolutionDataImpl data = new ResolutionDataImpl(this.executionEnvironment);
                data.setRootIUs(root.rootIUs);
                data.setAvailableIUsAndFilter(root.localUnits);
                SlicerResolutionStrategy strategy = this.getSlicerResolutionStrategy(data, true);
                Collection<IInstallableUnit> resolve = strategy.multiPlatformResolve(this.environments, new DuplicateFilteringLoggingProgressMonitor(this.logger));
                if (resolve.isEmpty()) continue;
                collector.addAll(resolve);
                if (!this.includeSource.booleanValue()) continue;
                collector.addAll(InstallableUnitResolver.addSourceBundleUnits(data, d -> this.getSlicerResolutionStrategy((ResolutionData)d, false), resolve, new DuplicateFilteringLoggingProgressMonitor(this.logger)));
            }
        }
        return collector;
    }

    private boolean haveContent() {
        for (RootUnits root : this.rootUnits) {
            if (root.rootIUs.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private SlicerResolutionStrategy getSlicerResolutionStrategy(ResolutionData data, boolean warn) {
        SlicerResolutionStrategy strategy = new SlicerResolutionStrategy(this.logger, this.includeAllEnvironments, warn);
        strategy.setData(data);
        return strategy;
    }

    private ProjectorResolutionStrategy getPlannerResolutionStrategy(ResolutionData data) throws TargetDefinitionResolutionException {
        if (this.includeAllEnvironments.booleanValue()) {
            this.logger.warn("includeAllPlatforms='true' and includeMode='planner' are incompatible. Ignoring 'includeAllPlatforms' flag");
        }
        ProjectorResolutionStrategy strategy = new ProjectorResolutionStrategy(this.logger);
        strategy.setData(data);
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<IInstallableUnit> addSourceBundleUnits(ResolutionDataImpl data, Function<ResolutionData, AbstractResolutionStrategy> strategySupplier, Collection<IInstallableUnit> units, IProgressMonitor progressMonitor) throws ResolverException {
        IRequirement bundleRequirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", null, null, (boolean)false, (boolean)false, (boolean)false);
        ArrayList<IRequirement> sourceBundleRequirements = new ArrayList<IRequirement>();
        for (IInstallableUnit unit : units) {
            if (!unit.satisfies(bundleRequirement)) continue;
            VersionRange perfectVersionMatch = new VersionRange(unit.getVersion(), true, unit.getVersion(), true);
            IRequirement optionalGreedySourceBundleRequirement = MetadataFactory.createRequirement((String)"osgi.bundle", (String)(unit.getId() + ".source"), (VersionRange)perfectVersionMatch, null, (boolean)true, (boolean)false, (boolean)true);
            sourceBundleRequirements.add(optionalGreedySourceBundleRequirement);
        }
        MetadataFactory.InstallableUnitDescription sourceDescription = new MetadataFactory.InstallableUnitDescription();
        sourceDescription.setId(SOURCE_IU_ID);
        Version sourceIUVersion = Version.createOSGi((int)1, (int)0, (int)0);
        sourceDescription.setVersion(sourceIUVersion);
        IProvidedCapability capability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)SOURCE_IU_ID, (Version)sourceIUVersion);
        sourceDescription.setCapabilities(new IProvidedCapability[]{capability});
        sourceDescription.addRequirements(sourceBundleRequirements);
        IInstallableUnit sourceIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)sourceDescription);
        Collection<IInstallableUnit> oldUis = data.getRootIUs();
        try {
            data.setRootIUs(Collections.singleton(sourceIU));
            TargetEnvironment nonFilteringEnvironment = new TargetEnvironment();
            Collection<IInstallableUnit> sourceUnits = strategySupplier.apply(data).resolve(nonFilteringEnvironment, progressMonitor);
            sourceUnits.remove(sourceIU);
            Collection<IInstallableUnit> collection = sourceUnits;
            return collection;
        }
        finally {
            data.setRootIUs(oldUis);
        }
    }

    private static Collection<IInstallableUnit> getRootIUs(Collection<? extends TargetDefinition.Unit> unitReferences, IQueryable<IInstallableUnit> queryable) {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        for (TargetDefinition.Unit unit : unitReferences) {
            result.add(InstallableUnitResolver.findUnits(unit, queryable));
        }
        return result;
    }

    private static IInstallableUnit findUnits(TargetDefinition.Unit unitReference, IQueryable<IInstallableUnit> queryable) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException {
        IQueryResult<IInstallableUnit> queryResult = InstallableUnitResolver.findUnit(unitReference, queryable);
        if (queryResult.isEmpty()) {
            throw new TargetDefinitionResolutionException(NLS.bind((String)"Could not find \"{0}/{1}\" in the repositories of the current location", (Object)unitReference.getId(), (Object)unitReference.getVersion()));
        }
        IInstallableUnit unitInstance = (IInstallableUnit)queryResult.iterator().next();
        return unitInstance;
    }

    private static IQueryResult<IInstallableUnit> findUnit(TargetDefinition.Unit unitReference, IQueryable<IInstallableUnit> units) throws TargetDefinitionSyntaxException {
        Version version = InstallableUnitResolver.parseVersion(unitReference);
        IQuery matchingIUQuery = QueryUtil.createIUQuery((String)unitReference.getId(), (Version)version);
        IQuery latestMatchingIUQuery = QueryUtil.createLatestQuery((IQuery)matchingIUQuery);
        IQueryResult queryResult = units.query(latestMatchingIUQuery, (IProgressMonitor)new NullProgressMonitor());
        return queryResult;
    }

    private static Version parseVersion(TargetDefinition.Unit unitReference) throws TargetDefinitionSyntaxException {
        try {
            return Version.parseVersion((String)unitReference.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new TargetDefinitionSyntaxException(NLS.bind((String)"Cannot parse version \"{0}\" of unit \"{1}\"", (Object)unitReference.getVersion(), (Object)unitReference.getId()), (Throwable)e);
        }
    }

    private static final class RootUnits {
        private Collection<IInstallableUnit> rootIUs;
        private IQueryable<IInstallableUnit> localUnits;

        public RootUnits(Collection<IInstallableUnit> rootIUs, IQueryable<IInstallableUnit> localUnits) {
            this.rootIUs = rootIUs;
            this.localUnits = localUnits;
        }
    }

    private static class UnitCollector
    extends Collector<IInstallableUnit> {
        private UnitCollector() {
        }

        public void addAll(Collection<? extends IInstallableUnit> units) {
            for (IInstallableUnit iInstallableUnit : units) {
                this.accept(iInstallableUnit);
            }
        }
    }
}

