/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.ArtifactSinkException;
import org.eclipse.tycho.IArtifactSink;
import org.eclipse.tycho.IRawArtifactFileProvider;
import org.eclipse.tycho.IRawArtifactSink;

class MissingBundlesArtifactFileProvider
implements IRawArtifactFileProvider {
    private Map<IArtifactKey, File> mappedFiles = new HashMap<IArtifactKey, File>();

    MissingBundlesArtifactFileProvider() {
    }

    public File getArtifactFile(IArtifactKey key) {
        return this.mappedFiles.get(key);
    }

    public boolean isFileAlreadyAvailable(IArtifactKey artifactKey) {
        return this.contains(artifactKey);
    }

    public boolean contains(IArtifactKey key) {
        return this.mappedFiles.containsKey(key);
    }

    public IStatus getArtifact(IArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException {
        return Status.CANCEL_STATUS;
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        return query.perform(this.mappedFiles.keySet().iterator());
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        return new IArtifactDescriptor[0];
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        return false;
    }

    public IStatus getRawArtifact(IRawArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException {
        return Status.CANCEL_STATUS;
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        return this.getArtifactFile(descriptor.getArtifactKey());
    }

    void add(IArtifactKey key, File file) {
        this.mappedFiles.put(key, file);
    }
}

