/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.MavenDependencyDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.MavenBundleResolver;
import org.eclipse.tycho.core.resolver.P2Resolver;
import org.eclipse.tycho.core.resolver.P2ResolverFactory;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.eclipse.tycho.p2resolver.P2ResolverImpl;
import org.eclipse.tycho.p2resolver.PomDependencyCollectorImpl;
import org.eclipse.tycho.p2resolver.PomUnits;
import org.eclipse.tycho.p2resolver.ResolutionData;
import org.eclipse.tycho.p2resolver.TargetDefinitionResolverService;

@Component(role=P2ResolverFactory.class)
public class P2ResolverFactoryImpl
implements P2ResolverFactory {
    @Requirement
    IProvisioningAgent agent;
    @Requirement
    private MavenContext mavenContext;
    @Requirement
    private LocalRepositoryP2Indices localRepoIndices;
    @Requirement
    private TargetDefinitionResolverService targetDefinitionResolverService;
    private ConcurrentMap<IInstallableUnit, Optional<Map.Entry<IInstallableUnit, IRequiredCapability>>> hostRequirementMap = new ConcurrentHashMap<IInstallableUnit, Optional<Map.Entry<IInstallableUnit, IRequiredCapability>>>();
    @Requirement
    private TychoProjectManager projectManager;
    @Requirement
    private PomUnits pomUnits;
    @Requirement
    private Logger logger;
    @Requirement
    private IRepositoryIdManager repositoryIdManager;
    @Requirement
    private MavenBundleResolver bundleResolver;
    @Requirement
    private TargetPlatformFactory targetPlatformFactory;

    private IProvisioningAgent getAgent() {
        this.agent.getService(IArtifactRepositoryManager.class);
        return this.agent;
    }

    public PomUnits getPomUnits() {
        return this.pomUnits;
    }

    @Override
    public PomDependencyCollector newPomDependencyCollector(ReactorProject project) {
        return new PomDependencyCollectorImpl(this.logger, project, this.getAgent());
    }

    @Override
    public P2Resolver createResolver(Collection<TargetEnvironment> environments) {
        return new P2ResolverImpl(this.targetPlatformFactory, this, this.mavenContext.getLogger(), environments);
    }

    public Set<IInstallableUnit> calculateDependencyFragments(ResolutionData data, Collection<IInstallableUnit> resolvedUnits) {
        Collection<IInstallableUnit> availableIUs = data.getAvailableIUs();
        List fragmentsList = availableIUs.stream().map(iu -> this.hostRequirementMap.computeIfAbsent((IInstallableUnit)iu, key -> {
            for (IProvidedCapability capability : iu.getProvidedCapabilities()) {
                String nameSpace = capability.getNamespace();
                if (!"osgi.fragment".equals(nameSpace)) continue;
                String hostName = capability.getName();
                return P2ResolverFactoryImpl.findFragmentHostRequirement(iu, hostName);
            }
            return Optional.empty();
        })).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ArrayList::new));
        if (fragmentsList.isEmpty()) {
            return Collections.emptySet();
        }
        MavenLogger logger = this.mavenContext.getLogger();
        if (logger.isExtendedDebugEnabled() && !fragmentsList.isEmpty()) {
            logger.debug("Possible candidate fragments:");
            for (Map.Entry fragmentEntry : fragmentsList) {
                logger.debug(" " + ((IInstallableUnit)fragmentEntry.getKey()).toString());
            }
        }
        Map<String, List<IInstallableUnit>> resolvedUnitsById = resolvedUnits.stream().collect(Collectors.groupingBy(iu -> iu.getId()));
        Map<String, List<IInstallableUnit>> matching = fragmentsList.stream().filter(entry -> {
            IRequiredCapability hostRequirement = (IRequiredCapability)entry.getValue();
            List potentialHosts = (List)resolvedUnitsById.get(hostRequirement.getName());
            if (potentialHosts == null) {
                return false;
            }
            for (IInstallableUnit potentialHost : potentialHosts) {
                if (!hostRequirement.isMatch(potentialHost)) continue;
                return true;
            }
            return false;
        }).map(entry -> (IInstallableUnit)entry.getKey()).collect(Collectors.groupingBy(IVersionedId::getId));
        Set<IInstallableUnit> filteredResult = matching.values().stream().map(candidates -> {
            if (candidates.size() == 1) {
                return (IInstallableUnit)candidates.get(0);
            }
            return candidates.stream().max(Comparator.comparing(IVersionedId::getVersion)).get();
        }).collect(Collectors.toSet());
        if (logger.isDebugEnabled() && !filteredResult.isEmpty()) {
            logger.info("Resolved fragments:");
            for (IInstallableUnit unit : filteredResult) {
                logger.info(" " + unit.toString());
            }
        }
        return filteredResult;
    }

    private static Optional<Map.Entry<IInstallableUnit, IRequiredCapability>> findFragmentHostRequirement(IInstallableUnit unit, String hostName) {
        for (IRequirement requirement : unit.getRequirements()) {
            IRequiredCapability requiredCapability;
            if (!(requirement instanceof IRequiredCapability) || !hostName.equals((requiredCapability = (IRequiredCapability)requirement).getName())) continue;
            return Optional.of(new AbstractMap.SimpleEntry<IInstallableUnit, IRequiredCapability>(unit, requiredCapability));
        }
        return Optional.empty();
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public void setLocalRepositoryIndices(LocalRepositoryP2Indices localRepoIndices) {
        this.localRepoIndices = localRepoIndices;
    }

    public void setTargetDefinitionResolverService(TargetDefinitionResolverService targetDefinitionResolverService) {
        this.targetDefinitionResolverService = targetDefinitionResolverService;
    }

    @Override
    public MavenDependencyDescriptor resolveDependencyDescriptor(ArtifactDescriptor artifactDescriptor) {
        return artifactDescriptor.getInstallableUnits().stream().filter(IInstallableUnit.class::isInstance).map(IInstallableUnit.class::cast).map(iu -> {
            final Map properties = iu.getProperties();
            final String groupId = (String)properties.get("maven-groupId");
            final String artifactId = (String)properties.get("maven-artifactId");
            final String version = (String)properties.get("maven-version");
            if (groupId == null || artifactId == null || version == null) {
                return null;
            }
            return new MavenDependencyDescriptor(){

                public String getVersion() {
                    return version;
                }

                public String getType() {
                    String type = (String)properties.get("maven-type");
                    if (type != null && !type.isBlank()) {
                        return type;
                    }
                    return (String)properties.get("maven-extension");
                }

                public String getGroupId() {
                    return groupId;
                }

                public String getClassifier() {
                    return (String)properties.get("maven-classifier");
                }

                public String getArtifactId() {
                    return artifactId;
                }

                public String getRepository() {
                    return (String)properties.get("maven-repository");
                }
            };
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public TychoProjectManager getProjectManager() {
        return this.projectManager;
    }
}

