/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.SimplePlanner;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.StatusTool;
import org.eclipse.tycho.p2.resolver.ResolverException;
import org.eclipse.tycho.p2resolver.AbstractSlicerResolutionStrategy;
import org.eclipse.tycho.p2resolver.ResolverDebugUtils;
import org.eclipse.tycho.p2tools.copiedfromp2.Projector;
import org.eclipse.tycho.p2tools.copiedfromp2.QueryableArray;
import org.eclipse.tycho.p2tools.copiedfromp2.Slicer;

public class ProjectorResolutionStrategy
extends AbstractSlicerResolutionStrategy {
    public ProjectorResolutionStrategy(MavenLogger logger) {
        super(logger);
    }

    @Override
    protected Slicer newSlicer(IQueryable<IInstallableUnit> availableUnits, Map<String, String> properties) {
        final Predicate<IInstallableUnit> acceptor = this.data.getIInstallableUnitAcceptor();
        return new Slicer(availableUnits, properties, false){

            @Override
            protected boolean isApplicable(IInstallableUnit iu) {
                if (acceptor != null) {
                    return acceptor.test(iu);
                }
                return super.isApplicable(iu);
            }
        };
    }

    @Override
    protected boolean isSlicerError(MultiStatus slicerStatus) {
        return slicerStatus.matches(12);
    }

    @Override
    public Collection<IInstallableUnit> resolve(Map<String, String> properties, IProgressMonitor monitor) throws ResolverException {
        ArrayList<IInstallableUnit> generatedUnits = new ArrayList<IInstallableUnit>();
        Map selectionContext = SimplePlanner.createSelectionContext(properties);
        LinkedHashSet<IInstallableUnit> seedUnits = new LinkedHashSet<IInstallableUnit>(this.data.getRootIUs());
        ArrayList<IRequirement> seedRequires = new ArrayList<IRequirement>();
        if (this.data.getAdditionalRequirements() != null) {
            seedRequires.addAll(this.data.getAdditionalRequirements());
        }
        seedUnits.addAll(this.data.getEEResolutionHints().getMandatoryUnits());
        seedRequires.addAll(this.data.getEEResolutionHints().getMandatoryRequires());
        Projector projector = new Projector(this.slice(properties, generatedUnits, monitor), selectionContext, new HashSet(), false){
            IQueryable<IInstallableUnit> units;

            @Override
            protected Collection<IRequirement> getRequiredCapabilities(IInstallableUnit iu) {
                Collection<IRequirement> requiredCapabilities = super.getRequiredCapabilities(iu);
                if (QueryUtil.isProduct((IInstallableUnit)iu)) {
                    if (this.units == null) {
                        this.units = ProjectorResolutionStrategy.this.data.units();
                    }
                    return requiredCapabilities.stream().filter(requirement -> {
                        IQuery query = QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0]);
                        IQueryResult result = this.units.query(query, null);
                        if (result.isEmpty()) {
                            return true;
                        }
                        return result.stream().anyMatch(matchIu -> this.isApplicable((IInstallableUnit)matchIu));
                    }).toList();
                }
                return requiredCapabilities;
            }
        };
        projector.encode(ProjectorResolutionStrategy.createUnitRequiring("tycho", seedUnits, seedRequires), EMPTY_IU_ARRAY, (IQueryable<IInstallableUnit>)new QueryableArray(List.of(), false), seedUnits, monitor);
        IStatus s = projector.invokeSolver(monitor);
        if (s.getSeverity() == 4) {
            Set<Explanation> explanation = this.getExplanation(projector);
            this.logger.debug(StatusTool.toLogMessage(s));
            this.explainProblems(explanation, MavenLogger::error);
            throw new ResolverException(explanation, selectionContext.toString(), StatusTool.findException(s));
        }
        if (s.getSeverity() == 2) {
            this.logger.warn(StatusTool.toLogMessage(s));
        }
        Collection<IInstallableUnit> newState = projector.extractSolution();
        newState.removeAll(this.data.getEEResolutionHints().getTemporaryAdditions());
        newState.removeAll(generatedUnits);
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Resolved IUs:\n" + ResolverDebugUtils.toDebugString(newState, false));
        }
        return newState;
    }

    private Set<Explanation> getExplanation(Projector projector) {
        try {
            return projector.getExplanation((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IllegalStateException e) {
            return Set.of();
        }
    }
}

