/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2tools.copiedfromp2;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.internal.repository.mirroring.FileMirrorLog;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.internal.repository.mirroring.Mirroring;
import org.eclipse.equinox.p2.internal.repository.mirroring.XMLMirrorLog;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.SlicingOptions;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.p2tools.copiedfromp2.AbstractApplication;
import org.eclipse.tycho.p2tools.copiedfromp2.PermissiveSlicer;
import org.eclipse.tycho.p2tools.copiedfromp2.RepositoryDescriptor;
import org.eclipse.tycho.p2tools.copiedfromp2.Slicer;

public class MirrorApplication
extends AbstractApplication
implements IApplication,
IExecutableExtension {
    private static final String DEFAULT_COMPARATOR = "org.eclipse.equinox.artifact.comparator.checksum.sha-256";
    private static final String LOG_ROOT = "p2.mirror";
    private static final String MIRROR_MODE = "metadataOrArtifacts";
    protected SlicingOptions slicingOptions = new SlicingOptions();
    protected List<TargetEnvironment> environments = new ArrayList<TargetEnvironment>();
    private URI baseline;
    private String comparatorID;
    private IQuery<IArtifactDescriptor> compareExclusions = null;
    private boolean compare = false;
    private boolean failOnError = true;
    private boolean raw = true;
    private boolean verbose = false;
    private boolean validate = false;
    private boolean mirrorReferences = true;
    private String metadataOrArtifacts = null;
    private String[] rootIUs = null;
    private boolean mirrorProperties = false;
    private File mirrorLogFile;
    private File comparatorLogFile;
    private IArtifactMirrorLog mirrorLog;
    private IArtifactMirrorLog comparatorLog;

    public MirrorApplication(IProvisioningAgent agent) {
        super(agent);
    }

    public static String[] getArrayArgsFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            if ((token.indexOf(91) >= 0 || token.indexOf(40) >= 0) && tokens.hasMoreTokens()) {
                result.add(token + separator + tokens.nextToken());
                continue;
            }
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public Object start(IApplicationContext context) throws Exception {
        Map args = context.getArguments();
        this.initializeFromArguments((String[])args.get("application.args"));
        this.run(null);
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if (data instanceof Map && ((Map)data).containsKey(MIRROR_MODE)) {
            this.metadataOrArtifacts = (String)((Map)data).get(MIRROR_MODE);
        }
    }

    public void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        File comparatorLogLocation = null;
        File mirrorLogLocation = null;
        RepositoryDescriptor destination = new RepositoryDescriptor();
        RepositoryDescriptor sourceRepo = new RepositoryDescriptor();
        if (this.metadataOrArtifacts != null) {
            destination.setKind(this.metadataOrArtifacts);
            sourceRepo.setKind(this.metadataOrArtifacts);
        }
        this.addDestination(destination);
        this.addSource(sourceRepo);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-raw")) {
                this.raw = true;
            } else if (args[i].equalsIgnoreCase("-ignoreErrors")) {
                this.failOnError = false;
            } else if (args[i].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
            } else if (args[i].equalsIgnoreCase("-compare")) {
                this.compare = true;
            } else if (args[i].equalsIgnoreCase("-validate")) {
                this.validate = true;
            } else if (args[i].equalsIgnoreCase("-references")) {
                this.mirrorReferences = true;
            } else if (args[i].equalsIgnoreCase("-properties")) {
                this.mirrorProperties = true;
            }
            if (i == args.length - 1 || args[i + 1].startsWith("-")) continue;
            String arg = args[++i];
            if (args[i - 1].equalsIgnoreCase("-comparator")) {
                this.comparatorID = arg;
                continue;
            }
            if (args[i - 1].equalsIgnoreCase("-comparatorLog")) {
                comparatorLogLocation = new File(arg);
                continue;
            }
            if (args[i - 1].equalsIgnoreCase("-destinationName")) {
                destination.setName(arg);
                continue;
            }
            if (args[i - 1].equalsIgnoreCase("-writeMode")) {
                if (!args[i].equalsIgnoreCase("clean")) continue;
                destination.setAppend(false);
                continue;
            }
            if (args[i - 1].equalsIgnoreCase("-log")) {
                mirrorLogLocation = new File(arg);
                continue;
            }
            if (args[i - 1].equalsIgnoreCase("-roots")) {
                this.rootIUs = MirrorApplication.getArrayArgsFromString(arg, ",");
                continue;
            }
            if (args[i - 1].equalsIgnoreCase("-references")) {
                this.mirrorReferences = Boolean.parseBoolean(args[i]);
                continue;
            }
            try {
                if (args[i - 1].equalsIgnoreCase("-source")) {
                    URI uri = RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg));
                    sourceRepo.setLocation(uri);
                    destination.setFormat(uri);
                    continue;
                }
                if (args[i - 1].equalsIgnoreCase("-destination")) {
                    destination.setLocation(RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg)));
                    continue;
                }
                if (!args[i - 1].equalsIgnoreCase("-compareAgainst")) continue;
                this.baseline = RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg));
                this.compare = true;
                continue;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.ProcessRepo_location_not_url, (Object)arg));
            }
        }
        if (mirrorLogLocation != null) {
            this.mirrorLog = this.getLog(mirrorLogLocation, "p2.artifact.mirror");
        }
        if (comparatorLogLocation != null && this.comparatorID != null) {
            this.comparatorLog = this.getLog(comparatorLogLocation, this.comparatorID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        AtomicReference<IStatus> mirrorStatus = new AtomicReference<IStatus>(Status.OK_STATUS);
        AtomicReference exception = new AtomicReference();
        try {
            this.initializeRepos((IProgressMonitor)new NullProgressMonitor());
            this.initializeLogs();
            this.validate();
            this.initializeIUs();
            IQueryable<IInstallableUnit> slice = this.slice((IProgressMonitor)new NullProgressMonitor());
            Set<IInstallableUnit> units = this.collectUnits(slice, monitor);
            if (this.destinationArtifactRepository != null) {
                this.destinationArtifactRepository.executeBatch(m -> {
                    try {
                        mirrorStatus.set(this.mirrorArtifacts(units, m));
                    }
                    catch (ProvisionException e) {
                        exception.set(e);
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
                if (exception.get() != null) {
                    throw (ProvisionException)((Object)exception.get());
                }
                if (this.failOnError && mirrorStatus.get().getSeverity() == 4) {
                    IStatus iStatus = mirrorStatus.get();
                    return iStatus;
                }
            }
            if (this.destinationMetadataRepository != null) {
                this.destinationMetadataRepository.executeBatch(m -> {
                    try {
                        this.mirrorMetadata(units, m);
                    }
                    catch (ProvisionException e) {
                        exception.set(e);
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
                if (exception.get() != null) {
                    throw (ProvisionException)((Object)exception.get());
                }
            }
        }
        finally {
            this.finalizeRepositories();
            this.finalizeLogs();
        }
        if (mirrorStatus.get().isOK()) {
            return Status.OK_STATUS;
        }
        return mirrorStatus.get();
    }

    private IStatus mirrorArtifacts(Collection<IInstallableUnit> slice, IProgressMonitor monitor) throws ProvisionException {
        Mirroring mirror = this.getMirroring(slice, monitor);
        MultiStatus result = mirror.run(this.failOnError, this.verbose);
        if (this.mirrorLog != null) {
            this.mirrorLog.log((IStatus)result);
        } else {
            LogHelper.log((IStatus)result);
        }
        return result;
    }

    protected Mirroring getMirroring(Collection<IInstallableUnit> ius, IProgressMonitor monitor) throws ProvisionException {
        boolean iusSpecified = !ius.isEmpty();
        List<IArtifactKey> keys = this.collectArtifactKeys(ius, monitor);
        Mirroring mirror = new Mirroring(this.getCompositeArtifactRepository(), this.destinationArtifactRepository, this.raw);
        mirror.setCompare(this.compare);
        mirror.setComparatorId(this.comparatorID == null ? DEFAULT_COMPARATOR : this.comparatorID);
        mirror.setBaseline(this.initializeBaseline());
        mirror.setValidate(this.validate);
        mirror.setCompareExclusions(this.compareExclusions);
        mirror.setTransport((Transport)this.agent.getService(Transport.SERVICE_NAME));
        mirror.setMirrorProperties(this.mirrorProperties);
        if (iusSpecified) {
            mirror.setArtifactKeys(keys.toArray(new IArtifactKey[keys.size()]));
        }
        if (this.comparatorLog != null) {
            mirror.setComparatorLog(this.comparatorLog);
        }
        return mirror;
    }

    protected List<IArtifactKey> collectArtifactKeys(Collection<IInstallableUnit> ius, IProgressMonitor monitor) throws ProvisionException {
        ArrayList<IArtifactKey> keys = new ArrayList<IArtifactKey>();
        for (IInstallableUnit iu : ius) {
            keys.addAll(iu.getArtifacts());
        }
        return keys;
    }

    private IArtifactRepository initializeBaseline() {
        if (this.baseline == null) {
            return null;
        }
        try {
            return this.addRepository(this.getArtifactRepositoryManager(), this.baseline, 0, null);
        }
        catch (ProvisionException e) {
            if (this.mirrorLog != null && e.getStatus() != null) {
                this.mirrorLog.log(e.getStatus());
            }
            return null;
        }
    }

    private void mirrorMetadata(Collection<IInstallableUnit> units, IProgressMonitor monitor) throws ProvisionException {
        this.destinationMetadataRepository.addInstallableUnits(units);
        if (this.mirrorReferences) {
            this.destinationMetadataRepository.addReferences(this.getCompositeMetadataRepository().getReferences());
        }
    }

    protected Set<IInstallableUnit> collectUnits(IQueryable<IInstallableUnit> slice, IProgressMonitor monitor) throws ProvisionException {
        IQueryResult allIUs = slice.query(QueryUtil.createIUAnyQuery(), monitor);
        Set units = allIUs.toSet();
        return units;
    }

    private void validate() throws ProvisionException {
        if (this.sourceRepositories.isEmpty()) {
            throw new ProvisionException(Messages.MirrorApplication_set_source_repositories);
        }
        if (!this.hasArtifactSources() && this.destinationArtifactRepository != null) {
            throw new ProvisionException(Messages.MirrorApplication_artifactDestinationNoSource);
        }
        if (!this.hasMetadataSources() && this.destinationMetadataRepository != null) {
            throw new ProvisionException(Messages.MirrorApplication_metadataDestinationNoSource);
        }
    }

    private void initializeIUs() throws ProvisionException {
        IMetadataRepository metadataRepo = this.getCompositeMetadataRepository();
        if (this.rootIUs != null) {
            this.sourceIUs = new ArrayList();
            for (String rootIU : this.rootIUs) {
                String[] segments = MirrorApplication.getArrayArgsFromString(rootIU, "/");
                VersionRange range = segments.length > 1 ? VersionRange.create((String)segments[1]) : null;
                Iterator queryResult = metadataRepo.query(QueryUtil.createIUQuery((String)segments[0], (VersionRange)range), null).iterator();
                while (queryResult.hasNext()) {
                    this.sourceIUs.add((IInstallableUnit)queryResult.next());
                }
            }
        } else if (this.sourceIUs == null || this.sourceIUs.isEmpty()) {
            this.sourceIUs = new ArrayList();
            Iterator queryResult = metadataRepo.query(QueryUtil.createIUAnyQuery(), null).iterator();
            while (queryResult.hasNext()) {
                this.sourceIUs.add((IInstallableUnit)queryResult.next());
            }
            if (this.sourceIUs.size() == 0 && this.destinationMetadataRepository != null && this.metadataOrArtifacts == null) {
                throw new ProvisionException(Messages.MirrorApplication_no_IUs);
            }
        }
    }

    private void initializeLogs() {
        if (this.compare && this.comparatorLogFile != null) {
            this.comparatorLog = this.getLog(this.comparatorLogFile, this.comparatorID);
        }
        if (this.mirrorLog == null && this.mirrorLogFile != null) {
            this.mirrorLog = this.getLog(this.mirrorLogFile, LOG_ROOT);
        }
    }

    private void finalizeLogs() {
        if (this.comparatorLog != null) {
            this.comparatorLog.close();
        }
        if (this.mirrorLog != null) {
            this.mirrorLog.close();
        }
    }

    private IArtifactMirrorLog getLog(File location, String root) {
        String absolutePath = location.getAbsolutePath();
        if (absolutePath.toLowerCase().endsWith(".xml")) {
            return new XMLMirrorLog(absolutePath, 0, root);
        }
        return new FileMirrorLog(absolutePath, 0, root);
    }

    private IQueryable<IInstallableUnit> performResolution(IProgressMonitor monitor) throws ProvisionException {
        List<Map<String, String>> filters = this.getContextFilters();
        IProfileRegistry registry = this.getProfileRegistry();
        String profileId = "MirrorApplication-" + System.currentTimeMillis();
        ArrayList<IQueryable> queryables = new ArrayList<IQueryable>();
        for (Map<String, String> filter : filters) {
            IProfile profile = registry.addProfile(profileId, filter);
            IPlanner planner = (IPlanner)this.agent.getService(IPlanner.class);
            if (planner == null) {
                throw new IllegalStateException();
            }
            IProfileChangeRequest pcr = planner.createChangeRequest(profile);
            pcr.addAll((Collection)this.sourceIUs);
            IProvisioningPlan plan = planner.getProvisioningPlan(pcr, null, monitor);
            registry.removeProfile(profileId);
            queryables.add(plan.getAdditions());
            IProvisioningPlan installerPlan = plan.getInstallerPlan();
            if (installerPlan == null) continue;
            queryables.add(installerPlan.getAdditions());
        }
        return QueryUtil.compoundQueryable(queryables);
    }

    protected List<Map<String, String>> getContextFilters() {
        return this.environments.isEmpty() ? List.of(this.slicingOptions.getFilter()) : this.environments.stream().map(environment -> {
            HashMap filter = new HashMap(this.slicingOptions.getFilter());
            filter.putAll(environment.toFilterProperties());
            return filter;
        }).toList();
    }

    private IProfileRegistry getProfileRegistry() throws ProvisionException {
        IProfileRegistry registry = (IProfileRegistry)this.agent.getService(IProfileRegistry.class);
        if (registry == null) {
            throw new ProvisionException(Messages.no_profile_registry);
        }
        return registry;
    }

    private IQueryable<IInstallableUnit> slice(IProgressMonitor monitor) throws ProvisionException {
        if (this.slicingOptions == null) {
            this.slicingOptions = new SlicingOptions();
        }
        if (this.slicingOptions.getInstallTimeLikeResolution()) {
            return this.performResolution(monitor);
        }
        Slicer slicer = this.createSlicer(this.slicingOptions);
        IQueryResult slice = slicer.slice(this.sourceIUs, monitor);
        if (slice != null && this.slicingOptions.latestVersionOnly()) {
            IQueryResult queryResult;
            slice = queryResult = slice.query(QueryUtil.createLatestIUQuery(), monitor);
        }
        if (slicer.getStatus().getSeverity() != 0 && this.mirrorLog != null) {
            this.mirrorLog.log((IStatus)slicer.getStatus());
        }
        if (slice == null) {
            throw new ProvisionException((IStatus)slicer.getStatus());
        }
        return slice;
    }

    protected Slicer createSlicer(SlicingOptions options) throws ProvisionException {
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable<IInstallableUnit>)this.getCompositeMetadataRepository(), options.getFilter(), options.includeOptionalDependencies(), options.isEverythingGreedy(), options.forceFilterTo(), options.considerStrictDependencyOnly(), options.followOnlyFilteredRequirements());
        return slicer;
    }

    public void setEnvironments(List<TargetEnvironment> environments) {
        this.environments = environments;
    }

    public void setSlicingOptions(SlicingOptions options) {
        this.slicingOptions = options;
    }

    public void setBaseline(URI baseline) {
        this.baseline = baseline;
        this.compare = true;
    }

    public void setComparatorID(String value) {
        this.comparatorID = value;
        this.compare = true;
    }

    public void setCompare(boolean value) {
        this.compare = value;
    }

    public void setIgnoreErrors(boolean value) {
        this.failOnError = !value;
    }

    public void setRaw(boolean value) {
        this.raw = value;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void setComparatorLog(File comparatorLog) {
        this.comparatorLogFile = comparatorLog;
    }

    public void setLog(File mirrorLog) {
        this.mirrorLogFile = mirrorLog;
    }

    public void setLog(IArtifactMirrorLog log) {
        this.mirrorLog = log;
    }

    public void setValidate(boolean value) {
        this.validate = value;
    }

    public void setReferences(boolean flag) {
        this.mirrorReferences = flag;
    }

    public void setComparatorExclusions(IQuery<IArtifactDescriptor> exclusions) {
        this.compareExclusions = exclusions;
    }

    public void setMirrorProperties(boolean mirrorProperties) {
        this.mirrorProperties = mirrorProperties;
    }
}

