/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model.project;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.tycho.model.project.EclipseProject;
import org.eclipse.tycho.model.project.ProjectVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ProjectParser {
    private static final Pattern PARENT_PROJECT_PATTERN = Pattern.compile("PARENT-(\\d+)-PROJECT_LOC");

    ProjectParser() {
    }

    public static EclipseProject parse(Path path) throws IOException {
        EclipseProject eclipseProject;
        block9: {
            InputStream stream = Files.newInputStream(path, new OpenOption[0]);
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(stream);
                Element root = doc.getDocumentElement();
                Node nameNode = root.getElementsByTagName("name").item(0);
                Node commentNode = root.getElementsByTagName("comment").item(0);
                final Path location = path.getParent();
                final String name = nameNode != null ? nameNode.getTextContent().strip() : location.getFileName().toString();
                final String comment = commentNode == null ? null : commentNode.getTextContent();
                NodeList natureNodes = root.getElementsByTagName("nature");
                int length = natureNodes.getLength();
                final HashSet<String> natureSet = new HashSet<String>();
                for (int i2 = 0; i2 < length; ++i2) {
                    natureSet.add(natureNodes.item(i2).getTextContent());
                }
                NodeList variableNodes = root.getElementsByTagName("variable");
                final List<ProjectVariable> variables = IntStream.range(0, variableNodes.getLength()).mapToObj(i -> variableNodes.item(i)).map(Element.class::cast).map(e -> ProjectParser.parseVariable(e)).filter(Objects::nonNull).toList();
                NodeList linkNodes = root.getElementsByTagName("link");
                final Map links = IntStream.range(0, linkNodes.getLength()).mapToObj(i -> linkNodes.item(i)).map(Element.class::cast).map(e -> ProjectParser.parseLink(e)).filter(Objects::nonNull).collect(Collectors.toMap(LinkDescription::name, Function.identity()));
                eclipseProject = new EclipseProject(){

                    public String toString() {
                        return this.getName() + " @ " + this.getLocation();
                    }

                    public int hashCode() {
                        return this.getLocation().hashCode();
                    }

                    public boolean equals(Object obj) {
                        if (obj instanceof EclipseProject) {
                            EclipseProject p = (EclipseProject)obj;
                            return p.getLocation().equals(this.getLocation());
                        }
                        return false;
                    }

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public Path getLocation() {
                        return location;
                    }

                    @Override
                    public boolean hasNature(String nature) {
                        return natureSet.contains(nature);
                    }

                    @Override
                    public String getComment() {
                        if (comment == null || comment.isBlank()) {
                            return null;
                        }
                        return comment;
                    }

                    @Override
                    public Path getFile(Path path) {
                        if (path == null) {
                            return null;
                        }
                        if (!path.isAbsolute()) {
                            path = location.resolve(path);
                        }
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            return path;
                        }
                        Path relative = location.relativize(path);
                        for (Map.Entry entry : links.entrySet()) {
                            Path linkPath = (Path)entry.getKey();
                            if (!relative.startsWith(linkPath)) continue;
                            LinkDescription link = (LinkDescription)entry.getValue();
                            if (link.type() == 1) {
                                if (!linkPath.startsWith(relative)) continue;
                                Path resolvedPath = ProjectParser.resolvePath(link.locationURI(), this);
                                return location.resolve(resolvedPath).normalize();
                            }
                            if (link.type() != 2) continue;
                            Path linkRelative = linkPath.relativize(relative);
                            Path resolvedPath = ProjectParser.resolvePath(link.locationURI(), this);
                            if (resolvedPath == null) continue;
                            return location.resolve(resolvedPath).resolve(linkRelative).normalize();
                        }
                        return path;
                    }

                    @Override
                    public Path getFile(String path) {
                        return this.getFile(location.resolve(path));
                    }

                    @Override
                    public Collection<ProjectVariable> getVariables() {
                        return variables;
                    }
                };
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | SAXException e2) {
                    throw new IOException("parsing failed", e2);
                }
            }
            stream.close();
        }
        return eclipseProject;
    }

    private static Path resolvePath(URI uri, EclipseProject project) {
        Path path;
        int count;
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        if (schemeSpecificPart != null && (count = (path = Path.of(schemeSpecificPart, new String[0])).getNameCount()) > 0) {
            Path first = path.getName(0);
            String name = first.toString();
            if ("PROJECT_LOC".equals(name)) {
                return ProjectParser.appendRemaining(path, count, project.getLocation());
            }
            Matcher parentMatcher = PARENT_PROJECT_PATTERN.matcher(name);
            if (parentMatcher.matches()) {
                Path resolvedPath = Path.of("..", new String[0]);
                int p = Integer.parseInt(parentMatcher.group(1));
                for (int i = 1; i < p; ++i) {
                    resolvedPath = resolvedPath.resolve("..");
                }
                return ProjectParser.appendRemaining(path, count, resolvedPath);
            }
            return path;
        }
        return null;
    }

    private static Path appendRemaining(Path path, int count, Path resolvedPath) {
        for (int i = 1; i < count; ++i) {
            resolvedPath = resolvedPath.resolve(path.getName(i));
        }
        return resolvedPath;
    }

    private static ProjectVariable parseVariable(Element element) {
        try {
            String name = element.getElementsByTagName("name").item(0).getTextContent();
            String value = element.getElementsByTagName("value").item(0).getTextContent();
            return new ProjectVariable(name, value);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private static LinkDescription parseLink(Element element) {
        try {
            String name = element.getElementsByTagName("name").item(0).getTextContent();
            String type = element.getElementsByTagName("type").item(0).getTextContent();
            String locationURI = element.getElementsByTagName("locationURI").item(0).getTextContent();
            return new LinkDescription(Path.of(name, new String[0]), Integer.parseInt(type), URI.create(locationURI));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    record LinkDescription(Path name, int type, URI locationURI) {
        static final int FILE = 1;
        static final int FOLDER = 2;
        static final int PROJECT = 4;
        static final int ROOT = 8;
    }
}

