/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.DependencySeed;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.Interpolator;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.maven.TychoInterpolator;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.p2.repository.PublishingRepository;
import org.eclipse.tycho.p2.repository.module.ModuleArtifactRepository;
import org.eclipse.tycho.p2.tools.publisher.facade.PublishProductTool;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherServiceFactory;
import org.eclipse.tycho.plugins.p2.publisher.AbstractPublishMojo;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManager;
import org.osgi.framework.Version;

@Mojo(name="publish-products", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class PublishProductMojo
extends AbstractPublishMojo {
    private static final Version LUNA_SR2_EXECUTABLE_FEATURE_VERSION = Version.parseVersion((String)"3.6.102.v20150204-1316");
    private static final String FLAVOR = "tooling";
    @Component(role=UnArchiver.class, hint="zip")
    private UnArchiver deflater;
    @Component
    private FileLockService fileLockService;
    @Component(role=TychoProject.class, hint="eclipse-repository")
    private EclipseRepositoryProject eclipseRepositoryProject;
    @Component
    private ReactorRepositoryManager reactorRepoManager;
    @Parameter(defaultValue="${project.basedir}")
    private File productsDirectory;
    @Parameter(defaultValue="jre")
    private String jreName;

    @Override
    protected Collection<DependencySeed> publishContent(PublisherServiceFactory publisherServiceFactory) throws MojoExecutionException, MojoFailureException {
        File artifactsXml;
        TychoInterpolator interpolator = new TychoInterpolator(this.getSession(), this.getProject());
        PublishProductTool publisher = publisherServiceFactory.createProductPublisher(this.getReactorProject(), this.getEnvironments(), this.getQualifier(), (Interpolator)interpolator);
        ArrayList<DependencySeed> seeds = new ArrayList<DependencySeed>();
        boolean hasLaunchers = false;
        for (File productFile : EclipseRepositoryProject.getProductFiles((File)this.productsDirectory)) {
            try {
                ProductConfiguration productConfiguration = ProductConfiguration.read((File)productFile);
                if (productConfiguration.getId() == null || productConfiguration.getId().isEmpty()) {
                    throw new MojoExecutionException("The product file " + productFile.getName() + " does not contain the mandatory attribute 'uid'. Please ensure you entered an id in the product file.");
                }
                if (productConfiguration.getVersion() == null || productConfiguration.getVersion().isEmpty()) {
                    throw new MojoExecutionException("The product file " + productFile.getName() + " does not contain the mandatory attribute 'version'. Please ensure you entered a version in the product file.");
                }
                boolean includeLaunchers = productConfiguration.includeLaunchers();
                seeds.addAll(publisher.publishProduct(productFile, includeLaunchers ? this.getExpandedLauncherBinaries() : null, FLAVOR, productConfiguration.includeJRE() ? this.jreName : null));
                hasLaunchers |= includeLaunchers;
            }
            catch (IOException e) {
                throw new MojoExecutionException("I/O exception while writing product definition or copying launcher icons", (Exception)e);
            }
        }
        if (hasLaunchers && (artifactsXml = new File(this.getProject().getBuild().getDirectory(), "p2artifacts.xml")).isFile()) {
            PublishingRepository publishingRepository = this.reactorRepoManager.getPublishingRepository(this.getReactorProject());
            final IFileArtifactRepository repository = publishingRepository.getArtifactRepository();
            repository.descriptorQueryable().query((IQuery)new IQuery<IArtifactDescriptor>(){

                public IQueryResult<IArtifactDescriptor> perform(Iterator<IArtifactDescriptor> iterator) {
                    while (iterator.hasNext()) {
                        IArtifactDescriptor descriptor = iterator.next();
                        File artifactFile = repository.getArtifactFile(descriptor);
                        if (artifactFile == null) continue;
                        try {
                            String digest = PublishProductMojo.this.digest(artifactFile);
                            PublishProductMojo.this.updateCheckSum(descriptor, digest);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        }
                        catch (IOException iOException) {}
                    }
                    return new Collector();
                }

                public IExpression getExpression() {
                    return null;
                }
            }, null);
            if (repository instanceof ModuleArtifactRepository) {
                ModuleArtifactRepository module = (ModuleArtifactRepository)repository;
                try {
                    module.saveToDisk();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return seeds;
    }

    private void updateCheckSum(IArtifactDescriptor descriptor, String digest) {
        if (descriptor instanceof org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor) {
            org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor arti = (org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor)descriptor;
            arti.setProperty("download.checksum.sha-256", digest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String digest(File artifactFile) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (DigestInputStream stream = new DigestInputStream(new FileInputStream(artifactFile), md);){
            try {
                stream.transferTo(OutputStream.nullOutputStream());
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        return HexFormat.of().formatHex(md.digest());
    }

    private File getExpandedLauncherBinaries() throws MojoExecutionException, MojoFailureException {
        File file;
        block11: {
            ArtifactDescriptor artifact = this.getLauncherArtifact();
            if (artifact == null) {
                throw new MojoExecutionException("Unable to locate feature 'org.eclipse.equinox.executable'. This feature is required for native product launchers.");
            }
            this.checkMacOSLauncherCompatibility(artifact);
            File equinoxExecFeature = (File)artifact.fetchArtifact().join();
            if (equinoxExecFeature.isDirectory()) {
                return equinoxExecFeature.getAbsoluteFile();
            }
            File unzipped = new File(this.getProject().getBuild().getDirectory(), artifact.getKey().getId() + "-" + artifact.getKey().getVersion());
            if (unzipped.exists()) {
                return unzipped.getAbsoluteFile();
            }
            Closeable locked = this.fileLockService.lock(equinoxExecFeature);
            try {
                unzipped.mkdirs();
                this.deflater.setSourceFile(equinoxExecFeature);
                this.deflater.setDestDirectory(unzipped);
                this.deflater.extract();
                file = unzipped.getAbsoluteFile();
                if (locked == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (locked != null) {
                        try {
                            locked.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ArchiverException e) {
                    throw new MojoFailureException("Unable to unzip the equinox executable feature", e);
                }
            }
            locked.close();
        }
        return file;
    }

    private ArtifactDescriptor getLauncherArtifact() {
        ReactorProject reactorProject = this.getReactorProject();
        Optional tychoProject = this.projectManager.getTychoProject(reactorProject);
        if (tychoProject.isEmpty()) {
            return null;
        }
        DependencyArtifacts dependencyArtifacts = ((TychoProject)tychoProject.get()).getDependencyArtifacts(reactorProject);
        ArtifactDescriptor artifact = dependencyArtifacts.getArtifact("eclipse-feature", "org.eclipse.equinox.executable", null);
        return artifact;
    }

    private void checkMacOSLauncherCompatibility(ArtifactDescriptor executablesFeature) throws MojoExecutionException {
        if (!this.macOSConfigured()) {
            return;
        }
        Version featureVersion = Version.parseVersion((String)executablesFeature.getKey().getVersion());
        if (PublishProductMojo.isLunaOrOlder(featureVersion)) {
            throw new MojoExecutionException("Detected Luna or older launcher feature org.eclipse.equinox.executable version " + featureVersion + ".\n Native product launchers for MacOSX can only be built against Eclipse Mars or newer.\nTo fix this, you can either build against Eclipse Mars or newer (recommended) or go back to Tycho <= 0.22.0");
        }
    }

    static boolean isLunaOrOlder(Version featureVersion) {
        return featureVersion.compareTo(LUNA_SR2_EXECUTABLE_FEATURE_VERSION) <= 0;
    }

    private boolean macOSConfigured() {
        for (TargetEnvironment env : this.getEnvironments()) {
            if (!"macosx".equals(env.getOs())) continue;
            return true;
        }
        return false;
    }
}

