/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.source;

import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.source.OsgiSourceMojo;
import org.osgi.framework.BundleException;

@Mojo(name="generate-pde-source-header", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PDESourceBundleMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="sourceBundleSuffix", defaultValue=".source")
    private String sourceBundleSuffix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String packaging = this.project.getPackaging();
        if ("jar".equals(packaging) || "bundle".equals(packaging)) {
            for (Artifact artifact : this.project.getAttachedArtifacts()) {
                if (!"sources".equalsIgnoreCase(artifact.getClassifier()) || !"java-source".equals(artifact.getType())) continue;
                File sourceFile = artifact.getFile();
                File hostFile = this.project.getArtifact().getFile();
                try (Jar hostBundle = new Jar(hostFile);
                     Jar sourceJar = new Jar(sourceFile);){
                    Attributes sourceMain = sourceJar.getManifest().getMainAttributes();
                    String hostName = hostBundle.getBsn();
                    String hostVersion = hostBundle.getVersion();
                    this.addBundleLocalicationFileIfAbsent(hostFile, hostName, sourceJar);
                    sourceMain.putValue("Bundle-ManifestVersion", "2");
                    sourceMain.putValue("Bundle-SymbolicName", hostName + this.sourceBundleSuffix);
                    sourceMain.putValue("Bundle-Version", hostVersion);
                    sourceMain.putValue("Eclipse-SourceBundle", hostName + ";version=\"" + hostVersion + "\";roots:=\".\"");
                    OsgiSourceMojo.addLocalicationHeaders(sourceMain::putValue);
                    String baseName = FilenameUtils.getBaseName((String)sourceFile.getName());
                    File outputFile = new File(sourceFile.getParentFile(), baseName + "-pde.jar");
                    sourceJar.write(outputFile);
                    artifact.setFile(outputFile);
                }
                catch (Exception e) {
                    throw new MojoFailureException("Update of manifest failed!", (Throwable)e);
                }
            }
        }
    }

    private void addBundleLocalicationFileIfAbsent(File hostFile, String hostName, Jar sourceJar) throws BundleException, MojoExecutionException, IOException {
        if (sourceJar.getResource("OSGI-INF/l10n/bundle-src.properties") == null) {
            try (FileSystem jarFS = FileSystems.newFileSystem(hostFile.toPath(), Map.of("create", "true"));){
                Path jarRoot = jarFS.getRootDirectories().iterator().next();
                CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap();
                try (InputStream manifest = Files.newInputStream(jarRoot.resolve("META-INF/MANIFEST.MF"), new OpenOption[0]);){
                    ManifestElement.parseBundleManifest((InputStream)manifest, (Map)headers);
                }
                Resource l10n = OsgiSourceMojo.generateL10nFile(this.project, jarRoot, ((Map)headers)::get, hostName, this.getLog());
                Path file = Path.of(l10n.getDirectory(), new String[0]).resolve("OSGI-INF/l10n/bundle-src.properties");
                sourceJar.putResource("OSGI-INF/l10n/bundle-src.properties", (aQute.bnd.osgi.Resource)new FileResource(file));
            }
        }
    }
}

