/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.api.util.ScanResult;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.surefire.AbstractEclipseTestMojo;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;

@Mojo(name="plugin-test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class TychoIntegrationTestMojo
extends AbstractEclipseTestMojo {
    @Parameter(property="project.build.testOutputDirectory")
    private File testClassesDirectory;
    @Parameter(property="tycho.plugin-test.skip")
    private boolean skipITs;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports/failsafe-summary.xml", required=true)
    private File summaryFile;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports", required=true)
    private File reportDirectory;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pluginRemoteRepositories;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> projectRemoteRepositories;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="tycho.plugin-test.packaging", defaultValue="eclipse-plugin")
    private String packaging = "eclipse-plugin";

    @Override
    protected boolean isCompatiblePackagingType(String projectPackaging) {
        return this.packaging.equals(projectPackaging);
    }

    @Override
    protected File getReportsDirectory() {
        return this.reportDirectory;
    }

    @Override
    protected File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    @Override
    protected boolean shouldSkip() {
        return this.skipITs || super.shouldSkip();
    }

    @Override
    protected PropertiesWrapper createSurefireProperties(TestFrameworkProvider provider, ScanResult scanResult) throws MojoExecutionException {
        PropertiesWrapper properties = super.createSurefireProperties(provider, scanResult);
        properties.setProperty("failifnotests", String.valueOf(false));
        properties.setProperty("failsafe", this.summaryFile.getAbsolutePath());
        return properties;
    }

    @Override
    protected void handleSuccess() {
    }

    @Override
    protected void handleTestFailures() {
    }

    @Override
    protected void setupTestBundles(Set<Artifact> testFrameworkBundles, EquinoxInstallationDescription testRuntime) throws MojoExecutionException {
        List dependencies = this.pluginDescriptor.getPlugin().getDependencies();
        if (dependencies.isEmpty()) {
            super.setupTestBundles(testFrameworkBundles, testRuntime);
        } else {
            super.setupTestBundles(Collections.emptySet(), testRuntime);
            for (Dependency dependency : dependencies) {
                ArtifactResolutionResult resolveArtifact = this.resolveDependency(dependency);
                for (Artifact artifact : resolveArtifact.getArtifacts()) {
                    File file = artifact.getFile();
                    if (file == null) continue;
                    testRuntime.addDevEntries("org.eclipse.tycho.surefire.osgibooter", file.getAbsolutePath());
                }
            }
        }
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        try {
            this.createTestPluginJar(reactorProject, "*;resolution:=optional", null).ifPresent(testPlugin -> {
                testRuntime.addBundle(testPlugin.getId(), testPlugin.getVersion(), testPlugin.getLocation());
                String bsn = testPlugin.getId();
                List testClasspath = this.osgiBundle.getTestClasspath(reactorProject, false);
                String testDevEntries = testClasspath.stream().map(ClasspathEntry::getLocations).flatMap(Collection::stream).map(File::getAbsolutePath).collect(Collectors.joining(","));
                testRuntime.addDevEntries(bsn, testDevEntries);
            });
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling test fragment JAR", e);
        }
    }

    @Override
    protected boolean useMetadataDirectory(ReactorProject otherProject) {
        File file;
        boolean meta = super.useMetadataDirectory(otherProject);
        if (meta && (file = this.project.getArtifact().getFile()) != null && file.isFile()) {
            return false;
        }
        return meta;
    }

    private ArtifactResolutionResult resolveDependency(Dependency dependency) {
        Artifact artifact = this.repositorySystem.createDependencyArtifact(dependency);
        ArrayList<ArtifactRepository> remoteRepositories = new ArrayList<ArtifactRepository>(32);
        remoteRepositories.addAll(this.pluginRemoteRepositories);
        remoteRepositories.addAll(this.projectRemoteRepositories);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setOffline(this.session.isOffline()).setArtifact(artifact).setLocalRepository(this.localRepository).setResolveTransitively(true).setCollectionFilter((ArtifactFilter)new ProviderDependencyArtifactFilter()).setRemoteRepositories(remoteRepositories);
        return this.repositorySystem.resolve(request);
    }

    private static final class ProviderDependencyArtifactFilter
    implements ArtifactFilter {
        static final Collection<String> SCOPES = List.of("compile", "compile+runtime", "runtime");

        private ProviderDependencyArtifactFilter() {
        }

        public boolean include(Artifact artifact) {
            String scope = artifact.getScope();
            return !artifact.isOptional() && (scope == null || SCOPES.contains(scope));
        }
    }
}

