/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.versions.bundle.MutableBundleManifest;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;

@Component(role=MetadataManipulator.class, hint="bundle-manifest")
public class BundleManifestManipulator
extends AbstractMetadataManipulator {
    @Override
    public void applyChange(ProjectMetadata project, VersionChange change, Set<VersionChange> allChanges) {
        if (this.isBundle(project) && this.isProjectVersionChange(project, change)) {
            MutableBundleManifest mf = this.getBundleManifest(project);
            this.logger.info("  META-INF/MANIFEST.MF//Bundle-Version: " + change.getVersion() + " => " + change.getNewVersion());
            mf.setVersion(change.getNewVersion());
            this.logger.info("  META-INF/MANIFEST.MF//Export-Package//version: " + change.getVersion() + " => " + change.getNewVersion().replace(".qualifier", ""));
            mf.setExportedPackageVersion(change.getVersion(), change.getNewVersion());
        }
    }

    @Override
    public Collection<String> validateChange(ProjectMetadata project, VersionChange change) {
        if (this.isBundle(project) && this.isProjectVersionChange(project, change)) {
            String error = Versions.validateOsgiVersion(change.getNewVersion(), this.getManifestFile(project));
            return error != null ? Collections.singleton(error) : null;
        }
        return null;
    }

    private boolean isProjectVersionChange(ProjectMetadata project, VersionChange change) {
        MutableBundleManifest mf = this.getBundleManifest(project);
        return change.getArtifactId().equals(mf.getSymbolicName()) && change.getVersion().equals(mf.getVersion());
    }

    private MutableBundleManifest getBundleManifest(ProjectMetadata project) {
        MutableBundleManifest mf = project.getMetadata(MutableBundleManifest.class);
        if (mf == null) {
            File file = this.getManifestFile(project);
            try {
                mf = MutableBundleManifest.read(file);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not parse bundle manifest " + file, e);
            }
            project.putMetadata(mf);
        }
        return mf;
    }

    private File getManifestFile(ProjectMetadata project) {
        return new File(project.getBasedir(), "META-INF/MANIFEST.MF");
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        MutableBundleManifest mf = project.getMetadata(MutableBundleManifest.class);
        if (mf != null) {
            MutableBundleManifest.write(mf, this.getManifestFile(project));
        }
    }
}

