/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.RuntimeTypeHolder;
import org.eclipse.yasson.internal.adapter.AbstractComponentBinding;
import org.eclipse.yasson.internal.adapter.AdapterBinding;
import org.eclipse.yasson.internal.adapter.ComponentBindings;
import org.eclipse.yasson.internal.adapter.DeserializerBinding;
import org.eclipse.yasson.internal.adapter.SerializerBinding;
import org.eclipse.yasson.model.JsonBindingModel;
import org.eclipse.yasson.model.PropertyModel;
import org.eclipse.yasson.model.TypeWrapper;

public class ComponentMatcher {
    private final JsonbContext jsonbContext;
    private final ConcurrentMap<Type, ComponentBindings> userComponents;

    ComponentMatcher(JsonbContext context) {
        Objects.requireNonNull(context);
        this.jsonbContext = context;
        this.userComponents = new ConcurrentHashMap<Type, ComponentBindings>();
        this.init();
    }

    void init() {
        JsonbAdapter[] adapters;
        JsonbDeserializer[] deserializers;
        JsonbSerializer[] serializers;
        for (JsonbSerializer serializer : serializers = (JsonbSerializer[])this.jsonbContext.getConfig().getProperty("jsonb.serializers").orElseGet(() -> new JsonbSerializer[0])) {
            this.introspectSerializerBinding(serializer.getClass(), serializer);
        }
        for (JsonbDeserializer deserializer : deserializers = (JsonbDeserializer[])this.jsonbContext.getConfig().getProperty("jsonb.derializers").orElseGet(() -> new JsonbDeserializer[0])) {
            this.introspectDeserializerBinding(deserializer.getClass(), deserializer);
        }
        for (JsonbAdapter adapter : adapters = (JsonbAdapter[])this.jsonbContext.getConfig().getProperty("jsonb.adapters").orElseGet(() -> new JsonbAdapter[0])) {
            this.introspectAdapterBinding(adapter.getClass(), adapter);
        }
    }

    private ComponentBindings getBindingInfo(Type type) {
        return this.userComponents.compute(type, (type1, bindingInfo) -> bindingInfo != null ? bindingInfo : new ComponentBindings((Type)type1));
    }

    private void addSerializer(Type bindingType, SerializerBinding serializer) {
        this.userComponents.computeIfPresent(bindingType, (type, bindings) -> {
            if (bindings.getSerializer() != null) {
                return bindings;
            }
            this.registerGeneric(bindingType);
            return new ComponentBindings(bindingType, serializer, bindings.getDeserializer(), bindings.getAdapterInfo());
        });
    }

    private void addDeserializer(Type bindingType, DeserializerBinding deserializer) {
        this.userComponents.computeIfPresent(bindingType, (type, bindings) -> {
            if (bindings.getDeserializer() != null) {
                return bindings;
            }
            this.registerGeneric(bindingType);
            return new ComponentBindings(bindingType, bindings.getSerializer(), deserializer, bindings.getAdapterInfo());
        });
    }

    private void addAdapter(Type bindingType, AdapterBinding adapter) {
        this.userComponents.computeIfPresent(bindingType, (type, bindings) -> {
            if (bindings.getAdapterInfo() != null) {
                return bindings;
            }
            this.registerGeneric(bindingType);
            return new ComponentBindings(bindingType, bindings.getSerializer(), bindings.getDeserializer(), adapter);
        });
    }

    private void registerGeneric(Type bindingType) {
        if (bindingType instanceof ParameterizedType && !this.jsonbContext.genericComponentsPresent()) {
            this.jsonbContext.registerGenericComponentFlag();
        }
    }

    public Optional<SerializerBinding<?>> getSerializerBinding(Type propertyRuntimeType, JsonBindingModel propertyModel) {
        if (propertyModel == null || propertyModel.getCustomization() == null || propertyModel.getCustomization().getSerializerBinding() == null) {
            return this.searchComponentBinding(propertyRuntimeType, ComponentBindings::getSerializer);
        }
        return this.getComponentBinding(propertyRuntimeType, propertyModel.getCustomization().getSerializerBinding());
    }

    public Optional<DeserializerBinding<?>> getDeserializerBinding(Type propertyRuntimeType, JsonBindingModel model) {
        if (model == null || model.getCustomization() == null || model.getCustomization().getDeserializerBinding() == null) {
            return this.searchComponentBinding(propertyRuntimeType, ComponentBindings::getDeserializer);
        }
        return this.getComponentBinding(propertyRuntimeType, model.getCustomization().getDeserializerBinding());
    }

    public Optional<AdapterBinding> getAdapterBinding(Type propertyRuntimeType, JsonBindingModel model) {
        if (model != null && model instanceof PropertyModel && ((PropertyModel)model).getClassModel().getType() == TypeWrapper.class) {
            return Optional.empty();
        }
        if (model == null || model.getCustomization() == null || model.getCustomization().getAdapterBinding() == null) {
            return this.searchComponentBinding(propertyRuntimeType, ComponentBindings::getAdapterInfo);
        }
        return this.getComponentBinding(propertyRuntimeType, model.getCustomization().getAdapterBinding());
    }

    private <T extends AbstractComponentBinding> Optional<T> getComponentBinding(Type propertyRuntimeType, T componentBinding) {
        if (this.matches(propertyRuntimeType, componentBinding.getBindingType())) {
            return Optional.of(componentBinding);
        }
        return Optional.empty();
    }

    private <T extends AbstractComponentBinding> Optional<T> searchComponentBinding(Type runtimeType, ComponentSupplier<T> supplier) {
        for (ComponentBindings componentBindings : this.userComponents.values()) {
            T component = supplier.getComponent(componentBindings);
            if (component == null || !this.matches(runtimeType, componentBindings.getBindingType())) continue;
            return Optional.of(component);
        }
        return Optional.empty();
    }

    private boolean matches(Type runtimeType, Type componentBindingType) {
        if (componentBindingType.equals(runtimeType)) {
            return true;
        }
        if (!this.jsonbContext.genericComponentsPresent()) {
            return false;
        }
        if (componentBindingType instanceof Class && runtimeType instanceof Class) {
            return ((Class)componentBindingType).isAssignableFrom((Class)runtimeType);
        }
        return runtimeType instanceof ParameterizedType && componentBindingType instanceof ParameterizedType && ReflectionUtils.getRawType(runtimeType) == ReflectionUtils.getRawType(componentBindingType) && this.matchTypeArguments((ParameterizedType)runtimeType, (ParameterizedType)componentBindingType);
    }

    private boolean matchTypeArguments(ParameterizedType requiredType, ParameterizedType componentBound) {
        Type[] adapterBoundTypeArguments;
        Type[] requiredTypeArguments = requiredType.getActualTypeArguments();
        if (requiredTypeArguments.length != (adapterBoundTypeArguments = componentBound.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < requiredTypeArguments.length; ++i) {
            Type adapterTypeArgument = adapterBoundTypeArguments[i];
            if (requiredTypeArguments[i].equals(adapterTypeArgument)) continue;
            return false;
        }
        return true;
    }

    AdapterBinding introspectAdapterBinding(Class<? extends JsonbAdapter> adapterClass, JsonbAdapter instance) {
        ParameterizedType adapterRuntimeType = ReflectionUtils.findParameterizedType(adapterClass, JsonbAdapter.class);
        Type[] adapterTypeArguments = adapterRuntimeType.getActualTypeArguments();
        Type adaptFromType = this.resolveTypeArg(adapterTypeArguments[0], adapterClass);
        Type adaptToType = this.resolveTypeArg(adapterTypeArguments[1], adapterClass);
        ComponentBindings componentBindings = this.getBindingInfo(adaptFromType);
        if (componentBindings.getAdapterInfo() != null && componentBindings.getAdapterInfo().getAdapter().getClass().equals(adapterClass)) {
            return componentBindings.getAdapterInfo();
        }
        JsonbAdapter newAdapter = instance != null ? instance : this.jsonbContext.getComponentInstanceCreator().getOrCreateComponent(adapterClass);
        AdapterBinding adapterInfo = new AdapterBinding(adaptFromType, adaptToType, newAdapter);
        this.addAdapter(adaptFromType, adapterInfo);
        return adapterInfo;
    }

    DeserializerBinding introspectDeserializerBinding(Class<? extends JsonbDeserializer> deserializerClass, JsonbDeserializer instance) {
        ParameterizedType deserializerRuntimeType = ReflectionUtils.findParameterizedType(deserializerClass, JsonbDeserializer.class);
        Type deserializerBindingType = this.resolveTypeArg(deserializerRuntimeType.getActualTypeArguments()[0], deserializerClass.getClass());
        ComponentBindings componentBindings = this.getBindingInfo(deserializerBindingType);
        if (componentBindings.getDeserializer() != null && componentBindings.getDeserializer().getClass().equals(deserializerClass)) {
            return componentBindings.getDeserializer();
        }
        JsonbDeserializer deserializer = instance != null ? instance : this.jsonbContext.getComponentInstanceCreator().getOrCreateComponent(deserializerClass);
        DeserializerBinding deserializerBinding = new DeserializerBinding(deserializerBindingType, deserializer);
        this.addDeserializer(deserializerBindingType, deserializerBinding);
        return deserializerBinding;
    }

    SerializerBinding introspectSerializerBinding(Class<? extends JsonbSerializer> serializerClass, JsonbSerializer instance) {
        ParameterizedType serializerRuntimeType = ReflectionUtils.findParameterizedType(serializerClass, JsonbSerializer.class);
        Type serBindingType = this.resolveTypeArg(serializerRuntimeType.getActualTypeArguments()[0], serializerClass.getClass());
        ComponentBindings componentBindings = this.getBindingInfo(serBindingType);
        if (componentBindings.getSerializer() != null && componentBindings.getSerializer().getClass().equals(serializerClass)) {
            return componentBindings.getSerializer();
        }
        JsonbSerializer serializer = instance != null ? instance : this.jsonbContext.getComponentInstanceCreator().getOrCreateComponent(serializerClass);
        SerializerBinding serializerBinding = new SerializerBinding(serBindingType, serializer);
        this.addSerializer(serBindingType, serializerBinding);
        return serializerBinding;
    }

    private Type resolveTypeArg(Type adapterTypeArg, Type adapterType) {
        if (adapterTypeArg instanceof ParameterizedType) {
            return ReflectionUtils.resolveTypeArguments((ParameterizedType)adapterTypeArg, adapterType);
        }
        if (adapterTypeArg instanceof TypeVariable) {
            return ReflectionUtils.resolveItemVariableType(new RuntimeTypeHolder(null, adapterType), (TypeVariable)adapterTypeArg);
        }
        return adapterTypeArg;
    }

    private static interface ComponentSupplier<T extends AbstractComponentBinding> {
        public T getComponent(ComponentBindings var1);
    }
}

