/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.util.Objects;
import javax.json.bind.JsonbConfig;
import javax.json.spi.JsonProvider;
import org.eclipse.yasson.internal.AnnotationIntrospector;
import org.eclipse.yasson.internal.ComponentMatcher;
import org.eclipse.yasson.internal.JsonbConfigProperties;
import org.eclipse.yasson.internal.MappingContext;
import org.eclipse.yasson.internal.cdi.JsonbComponentInstanceCreator;
import org.eclipse.yasson.internal.cdi.JsonbComponentInstanceCreatorFactory;

public class JsonbContext {
    private final JsonbConfig jsonbConfig;
    private final MappingContext mappingContext;
    private final JsonbComponentInstanceCreator componentInstanceCreator;
    private final JsonProvider jsonProvider;
    private final ComponentMatcher componentMatcher;
    private final AnnotationIntrospector annotationIntrospector;
    private boolean genericComponents;
    private JsonbConfigProperties configProperties;

    public JsonbContext(JsonbConfig jsonbConfig, JsonProvider jsonProvider) {
        Objects.requireNonNull(jsonbConfig);
        this.jsonbConfig = jsonbConfig;
        this.mappingContext = new MappingContext(this);
        this.componentInstanceCreator = JsonbComponentInstanceCreatorFactory.getComponentInstanceCreator();
        this.componentMatcher = new ComponentMatcher(this);
        this.annotationIntrospector = new AnnotationIntrospector(this);
        this.jsonProvider = jsonProvider;
        this.configProperties = new JsonbConfigProperties(jsonbConfig);
    }

    public JsonbConfig getConfig() {
        return this.jsonbConfig;
    }

    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    public JsonProvider getJsonProvider() {
        return this.jsonProvider;
    }

    public JsonbComponentInstanceCreator getComponentInstanceCreator() {
        return this.componentInstanceCreator;
    }

    public ComponentMatcher getComponentMatcher() {
        return this.componentMatcher;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this.annotationIntrospector;
    }

    public boolean genericComponentsPresent() {
        return this.genericComponents;
    }

    public void registerGenericComponentFlag() {
        this.genericComponents = true;
    }

    public JsonbConfigProperties getConfigProperties() {
        return this.configProperties;
    }
}

