/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.cdi;

import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.yasson.internal.cdi.BeanManagerInstanceCreator;
import org.eclipse.yasson.internal.cdi.DefaultConstructorCreator;
import org.eclipse.yasson.internal.cdi.JsonbComponentInstanceCreator;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonbComponentInstanceCreatorFactory {
    private static final Logger log = Logger.getLogger(JsonbComponentInstanceCreator.class.getName());
    public static final String BEAN_MANAGER_NAME = "java:comp/BeanManager";

    public static JsonbComponentInstanceCreator getComponentInstanceCreator() {
        try {
            return new BeanManagerInstanceCreator(CDI.current().getBeanManager());
        }
        catch (IllegalStateException e) {
            log.finest(Messages.getMessage(MessageKeys.BEAN_MANAGER_NOT_FOUND_NO_PROVIDER, new Object[0]));
            try {
                InitialContext context = new InitialContext();
                BeanManager lookup = (BeanManager)context.lookup(BEAN_MANAGER_NAME);
                return new BeanManagerInstanceCreator(lookup);
            }
            catch (NamingException e1) {
                log.finest(Messages.getMessage(MessageKeys.BEAN_MANAGER_NOT_FOUND_JNDI, BEAN_MANAGER_NAME, e1.getExplanation()));
                log.finest(Messages.getMessage(MessageKeys.BEAN_MANAGER_NOT_FOUND_USING_DEFAULT, new Object[0]));
                return new DefaultConstructorCreator();
            }
        }
    }
}

