/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.naming;

import java.nio.CharBuffer;
import org.eclipse.yasson.internal.naming.UpperCamelCaseStrategy;

public class UpperCamelCaseWithSpacesStrategy
extends UpperCamelCaseStrategy {
    @Override
    public String translateName(String propertyName) {
        String upperCased = super.translateName(propertyName);
        CharBuffer buffer = CharBuffer.allocate(upperCased.length() * 2);
        char last = '\u0000';
        for (int i = 0; i < upperCased.length(); ++i) {
            char current = upperCased.charAt(i);
            if (i > 0 && Character.isUpperCase(current) && this.isLowerCaseCharacter(last)) {
                buffer.append(' ');
            }
            last = current;
            buffer.append(current);
        }
        return new String(buffer.array(), 0, buffer.position());
    }

    private boolean isLowerCaseCharacter(char character) {
        return Character.isAlphabetic(character) && Character.isLowerCase(character);
    }
}

