/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.model.JsonBindingModel;

public abstract class AbstractValueTypeDeserializer<T>
implements JsonbDeserializer<T> {
    private final Class<T> clazz;
    private final JsonBindingModel model;

    public AbstractValueTypeDeserializer(Class<T> clazz, JsonBindingModel model) {
        this.clazz = clazz;
        this.model = model;
    }

    public T deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        Unmarshaller unmarshaller = (Unmarshaller)ctx;
        JsonParser.Event event = ((JsonbParser)parser).getCurrentLevel().getLastEvent();
        if (event == JsonParser.Event.VALUE_NULL) {
            return null;
        }
        String value = parser.getString();
        return this.deserialize(value, unmarshaller, rtType);
    }

    protected abstract T deserialize(String var1, Unmarshaller var2, Type var3);

    protected JsonBindingModel getModel() {
        return this.model;
    }
}

