/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.JsonbException;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.adapter.AdapterBinding;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.ContainerSerializerProvider;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;
import org.eclipse.yasson.internal.unmarshaller.CurrentItem;
import org.eclipse.yasson.model.ClassModel;
import org.eclipse.yasson.model.JsonBindingModel;
import org.eclipse.yasson.model.JsonContext;
import org.eclipse.yasson.model.JsonbPropertyInfo;
import org.eclipse.yasson.model.customization.Customization;

public class AdaptedObjectSerializer<T, A>
implements CurrentItem<T>,
JsonbSerializer<T> {
    private final JsonBindingModel model;
    private final AdapterBinding adapterInfo;

    public AdaptedObjectSerializer(JsonBindingModel model, AdapterBinding adapter) {
        this.model = new AdaptedObjectSerializerModel(model, adapter.getToType());
        this.adapterInfo = adapter;
    }

    public void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
        try {
            JsonbAdapter<?, ?> adapter = this.adapterInfo.getAdapter();
            Object adapted = adapter.adaptToJson(obj);
            JsonbSerializer<Object> serializer = this.resolveSerializer((Marshaller)ctx, adapted);
            serializer.serialize(adapted, generator, ctx);
        }
        catch (Exception e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.ADAPTER_EXCEPTION, this.adapterInfo.getBindingType(), this.adapterInfo.getToType(), this.adapterInfo.getAdapter().getClass()), (Throwable)e);
        }
    }

    private JsonbSerializer<A> resolveSerializer(Marshaller ctx, A adapted) {
        ContainerSerializerProvider cached = ctx.getMappingContext().getSerializerProvider(adapted.getClass());
        if (cached != null) {
            return cached.provideSerializer(new JsonbPropertyInfo().withWrapper(this).withRuntimeType(adapted.getClass()).withJsonBindingModel(this.model));
        }
        return ((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(ctx.getJsonbContext()).withObjectClass(adapted.getClass()).withModel(this.model)).withWrapper(this)).build();
    }

    @Override
    public ClassModel getClassModel() {
        return null;
    }

    @Override
    public CurrentItem<?> getWrapper() {
        return null;
    }

    @Override
    public JsonBindingModel getWrapperModel() {
        return this.model;
    }

    @Override
    public Type getRuntimeType() {
        return null;
    }

    private static final class AdaptedObjectSerializerModel
    implements JsonBindingModel {
        private final JsonBindingModel wrapperSerializerModel;
        private final Type adaptedType;

        public AdaptedObjectSerializerModel(JsonBindingModel wrapperSerializerModel, Type adaptedType) {
            this.wrapperSerializerModel = wrapperSerializerModel;
            this.adaptedType = adaptedType;
        }

        @Override
        public String getWriteName() {
            return this.wrapperSerializerModel.getWriteName();
        }

        @Override
        public JsonContext getContext() {
            return this.wrapperSerializerModel != null ? this.wrapperSerializerModel.getContext() : JsonContext.JSON_ARRAY;
        }

        @Override
        public Customization getCustomization() {
            return this.wrapperSerializerModel != null ? this.wrapperSerializerModel.getCustomization() : null;
        }

        @Override
        public Type getType() {
            return this.adaptedType;
        }
    }
}

