/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Locale;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeSerializer;
import org.eclipse.yasson.model.JsonBindingModel;

public class CalendarTypeSerializer
extends AbstractDateTimeSerializer<Calendar> {
    public CalendarTypeSerializer(JsonBindingModel model) {
        super(model);
    }

    @Override
    protected Instant toInstant(Calendar value) {
        return value.toInstant();
    }

    @Override
    protected String formatDefault(Calendar value, Locale locale) {
        DateTimeFormatter formatter = value.isSet(10) || value.isSet(11) ? DateTimeFormatter.ISO_DATE_TIME : DateTimeFormatter.ISO_DATE;
        return formatter.withZone(value.getTimeZone().toZoneId()).withLocale(locale).format(this.toTemporalAccessor(value));
    }

    @Override
    protected TemporalAccessor toTemporalAccessor(Calendar object) {
        return this.toZonedDateTime(object);
    }

    private ZonedDateTime toZonedDateTime(Calendar object) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(object.getTimeInMillis()), object.getTimeZone().toZoneId());
    }
}

