/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.AbstractContainerSerializer;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;
import org.eclipse.yasson.internal.unmarshaller.ContainerModel;
import org.eclipse.yasson.internal.unmarshaller.EmbeddedItem;
import org.eclipse.yasson.model.JsonBindingModel;
import org.eclipse.yasson.model.JsonContext;

public class CollectionSerializer<T extends Collection>
extends AbstractContainerSerializer<T>
implements EmbeddedItem {
    private final JsonBindingModel containerModel;
    private final Type collectionValueType = this.getValueType();
    private final JsonbSerializer valueSerializer;

    protected CollectionSerializer(SerializerBuilder builder) {
        super(builder);
        this.containerModel = new ContainerModel(this.collectionValueType, this.resolveContainerModelCustomization(this.collectionValueType, builder.getJsonbContext()), JsonContext.JSON_ARRAY);
        this.valueSerializer = this.resolveValueSerializer(this.collectionValueType, builder.getJsonbContext());
    }

    private JsonbSerializer resolveValueSerializer(Type collectionValueType, JsonbContext jsonbContext) {
        if (collectionValueType == Object.class) {
            return null;
        }
        Optional<Class<?>> optionalRawType = ReflectionUtils.getOptionalRawType(collectionValueType);
        if (!optionalRawType.isPresent()) {
            return null;
        }
        return ((SerializerBuilder)((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(jsonbContext).withType(collectionValueType)).withObjectClass(optionalRawType.get()).withWrapper(this)).withModel(this.containerModel)).build();
    }

    private Type getValueType() {
        return this.getRuntimeType() instanceof ParameterizedType ? ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[0]) : Object.class;
    }

    @Override
    protected void serializeInternal(T collection, JsonGenerator generator, SerializationContext ctx) {
        for (Object item : collection) {
            if (item == null) {
                generator.writeNull();
                continue;
            }
            if (this.valueSerializer != null) {
                this.serializerCaptor(this.valueSerializer, item, generator, ctx);
                continue;
            }
            JsonbSerializer<?> serializer = ((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(((Marshaller)ctx).getJsonbContext()).withObjectClass(item.getClass()).withWrapper(this)).withModel(this.containerModel)).build();
            this.serializerCaptor(serializer, item, generator, ctx);
        }
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartArray();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartArray(key);
    }
}

