/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.model.JsonBindingModel;

abstract class DateTimeFormatterSerializer<T extends TemporalAccessor>
extends AbstractValueTypeSerializer<T> {
    DateTimeFormatterSerializer(JsonBindingModel model) {
        super(model);
    }

    protected DateTimeFormatter getFormatter(JsonbContext jsonbContext) {
        if (this.model != null && this.model.getCustomization() != null && this.model.getCustomization().getSerializeDateFormatter() != null) {
            JsonbDateFormatter serializeDateFormatter = this.model.getCustomization().getSerializeDateFormatter();
            if (serializeDateFormatter.isDefault()) {
                return jsonbContext.getConfigProperties().isStrictIJson() ? JsonbDateFormatter.IJSON_DATE_FORMATTER : this.getDefaultFormatter();
            }
            if (serializeDateFormatter.getDateTimeFormatter() != null) {
                return serializeDateFormatter.getDateTimeFormatter();
            }
        }
        return this.getDefaultFormatter();
    }

    protected abstract DateTimeFormatter getDefaultFormatter();
}

