/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.AbstractContainerSerializer;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;
import org.eclipse.yasson.internal.unmarshaller.CurrentItem;
import org.eclipse.yasson.model.ClassModel;
import org.eclipse.yasson.model.JsonBindingModel;
import org.eclipse.yasson.model.PropertyModel;

public class ObjectSerializer<T>
extends AbstractContainerSerializer<T> {
    public ObjectSerializer(SerializerBuilder builder) {
        super(builder);
    }

    public ObjectSerializer(CurrentItem<?> wrapper, Type runtimeType, ClassModel classModel, JsonBindingModel wrapperModel) {
        super(wrapper, runtimeType, classModel, wrapperModel);
    }

    @Override
    protected void serializeInternal(T object, JsonGenerator generator, SerializationContext ctx) {
        PropertyModel[] allProperties;
        for (PropertyModel model : allProperties = ((Marshaller)ctx).getMappingContext().getOrCreateClassModel(object.getClass()).getSortedProperties()) {
            this.marshallProperty(object, generator, ctx, model);
        }
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartObject();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartObject(key);
    }

    private void marshallProperty(T object, JsonGenerator generator, SerializationContext ctx, PropertyModel propertyModel) {
        Marshaller marshaller = (Marshaller)ctx;
        Object propertyValue = propertyModel.getValue(object);
        if (propertyValue == null) {
            if (propertyModel.getCustomization().isNillable()) {
                generator.writeNull(propertyModel.getWriteName());
            }
            return;
        }
        JsonbSerializer<?> propertyCachedSerializer = propertyModel.getPropertySerializer();
        if (propertyCachedSerializer != null) {
            this.serializerCaptor(propertyCachedSerializer, propertyValue, generator, ctx);
            return;
        }
        Type genericType = ReflectionUtils.resolveType(this, propertyModel.getType());
        JsonbSerializer<?> serializer = ((SerializerBuilder)((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(marshaller.getJsonbContext()).withWrapper(this)).withObjectClass(propertyValue.getClass()).withModel(propertyModel)).withType(genericType)).build();
        this.serializerCaptor(serializer, propertyValue, generator, ctx);
    }
}

