/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeDeserializer;
import org.eclipse.yasson.model.JsonBindingModel;

public class ZonedDateTimeTypeDeserializer
extends AbstractDateTimeDeserializer<ZonedDateTime> {
    private static final Logger log = Logger.getLogger(ZonedDateTimeTypeDeserializer.class.getName());

    public ZonedDateTimeTypeDeserializer(JsonBindingModel model) {
        super(ZonedDateTime.class, model);
    }

    @Override
    protected ZonedDateTime fromInstant(Instant instant) {
        log.warning(Messages.getMessage(MessageKeys.OFFSET_DATE_TIME_FROM_MILLIS, ZonedDateTime.class.getSimpleName(), UTC));
        return ZonedDateTime.ofInstant(instant, UTC);
    }

    @Override
    protected ZonedDateTime parseDefault(String jsonValue, Locale locale) {
        return ZonedDateTime.parse(jsonValue, DateTimeFormatter.ISO_ZONED_DATE_TIME.withLocale(locale));
    }

    @Override
    protected ZonedDateTime parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        return ZonedDateTime.parse(jsonValue, formatter);
    }
}

