/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.unmarshaller;

import java.lang.reflect.GenericArrayType;
import java.util.List;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.unmarshaller.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.unmarshaller.ContainerModel;
import org.eclipse.yasson.internal.unmarshaller.DeserializerBuilder;
import org.eclipse.yasson.internal.unmarshaller.EmbeddedItem;
import org.eclipse.yasson.model.JsonBindingModel;

public abstract class AbstractArrayDeserializer<T>
extends AbstractContainerDeserializer<T>
implements EmbeddedItem {
    protected final Class<?> componentClass = this.getRuntimeType() instanceof GenericArrayType ? ReflectionUtils.resolveRawType(this, ((GenericArrayType)this.getRuntimeType()).getGenericComponentType()) : ReflectionUtils.getRawType(this.getRuntimeType()).getComponentType();
    private final JsonBindingModel model;

    protected AbstractArrayDeserializer(DeserializerBuilder builder) {
        super(builder);
        this.model = new ContainerModel(this.componentClass, this.resolveContainerModelCustomization(this.componentClass, builder.getJsonbContext()));
    }

    @Override
    protected JsonBindingModel getModel() {
        return this.model;
    }

    @Override
    public void appendResult(Object result) {
        this.appendCaptor(this.convertNullToOptionalEmpty(this.getModel(), result));
    }

    private <X> void appendCaptor(X value) {
        this.getItems().add(value);
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        JsonbDeserializer<?> deserializer = ((DeserializerBuilder)((DeserializerBuilder)this.newUnmarshallerItemBuilder(context.getJsonbContext()).withType(this.componentClass)).withModel(this.model)).build();
        this.appendResult(deserializer.deserialize(parser, (DeserializationContext)context, this.componentClass));
    }

    protected abstract List<?> getItems();

    @Override
    protected JsonbRiParser.LevelContext moveToFirst(JsonbParser parser) {
        parser.moveTo(JsonParser.Event.START_ARRAY);
        return parser.getCurrentLevel();
    }
}

