/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.unmarshaller;

import java.lang.reflect.Type;
import org.eclipse.yasson.internal.AbstractSerializerBuilder;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.unmarshaller.CurrentItem;
import org.eclipse.yasson.model.ClassModel;
import org.eclipse.yasson.model.JsonBindingModel;
import org.eclipse.yasson.model.customization.ClassCustomizationBuilder;
import org.eclipse.yasson.model.customization.ContainerCustomization;
import org.eclipse.yasson.model.customization.Customization;

public abstract class AbstractItem<T>
implements CurrentItem<T> {
    private final CurrentItem<?> wrapper;
    private final Type runtimeType;
    private final ClassModel classModel;
    private final JsonBindingModel wrapperModel;

    protected AbstractItem(AbstractSerializerBuilder builder) {
        this.wrapper = builder.getWrapper();
        this.wrapperModel = builder.getModel();
        this.classModel = builder.getClassModel();
        this.runtimeType = builder.getRuntimeType();
    }

    public AbstractItem(CurrentItem<?> wrapper, Type runtimeType, ClassModel classModel, JsonBindingModel wrapperModel) {
        this.wrapper = wrapper;
        this.runtimeType = runtimeType;
        this.classModel = classModel;
        this.wrapperModel = wrapperModel;
    }

    @Override
    public ClassModel getClassModel() {
        return this.classModel;
    }

    @Override
    public CurrentItem<?> getWrapper() {
        return this.wrapper;
    }

    @Override
    public JsonBindingModel getWrapperModel() {
        return this.wrapperModel;
    }

    @Override
    public Type getRuntimeType() {
        return this.runtimeType;
    }

    protected Customization resolveContainerModelCustomization(Type componentType, JsonbContext jsonbContext) {
        Class<?> valueRawType = ReflectionUtils.resolveRawType(this, componentType);
        ClassModel classModel = jsonbContext.getMappingContext().getClassModel(valueRawType);
        if (classModel != null) {
            return new ContainerCustomization(classModel.getCustomization());
        }
        return new ContainerCustomization(new ClassCustomizationBuilder());
    }
}

