/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.unmarshaller;

import java.math.BigDecimal;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonValue;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.unmarshaller.AbstractJsonpDeserializer;
import org.eclipse.yasson.internal.unmarshaller.DeserializerBuilder;

public class JsonArrayDeserializer
extends AbstractJsonpDeserializer<JsonArray> {
    private final JsonArrayBuilder arrayBuilder;

    @Override
    protected void appendString(String key, String value) {
        this.arrayBuilder.add(value);
    }

    @Override
    protected void appendNumber(String key, BigDecimal value) {
        this.arrayBuilder.add(value);
    }

    @Override
    protected void appendBoolean(String key, Boolean value) {
        this.arrayBuilder.add(value.booleanValue());
    }

    @Override
    protected void appendNull(String key) {
        this.arrayBuilder.addNull();
    }

    protected JsonArrayDeserializer(DeserializerBuilder builder) {
        super(builder);
        this.arrayBuilder = builder.getJsonbContext().getJsonProvider().createArrayBuilder();
    }

    @Override
    public void appendResult(Object result) {
        JsonValue jsonValue = (JsonValue)result;
        this.arrayBuilder.add(jsonValue);
    }

    @Override
    public JsonArray getInstance(Unmarshaller unmarshaller) {
        return this.arrayBuilder.build();
    }
}

