/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.unmarshaller;

import java.math.BigDecimal;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.unmarshaller.AbstractJsonpDeserializer;
import org.eclipse.yasson.internal.unmarshaller.DeserializerBuilder;

public class JsonObjectDeserializer
extends AbstractJsonpDeserializer<JsonObject> {
    private JsonObjectBuilder objectBuilder;

    protected JsonObjectDeserializer(DeserializerBuilder builder) {
        super(builder);
        this.objectBuilder = builder.getJsonbContext().getJsonProvider().createObjectBuilder();
    }

    @Override
    protected void appendString(String key, String value) {
        this.objectBuilder.add(key, value);
    }

    @Override
    protected void appendNumber(String key, BigDecimal value) {
        this.objectBuilder.add(key, value);
    }

    @Override
    protected void appendBoolean(String key, Boolean value) {
        this.objectBuilder.add(key, value.booleanValue());
    }

    @Override
    protected void appendNull(String key) {
        this.objectBuilder.addNull(key);
    }

    @Override
    public void appendResult(Object result) {
        this.objectBuilder.add(this.parserContext.getLastKeyName(), (JsonValue)result);
    }

    @Override
    public JsonObject getInstance(Unmarshaller unmarshaller) {
        return this.objectBuilder.build();
    }
}

