/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.unmarshaller;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.unmarshaller.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.unmarshaller.ContainerModel;
import org.eclipse.yasson.internal.unmarshaller.DeserializerBuilder;
import org.eclipse.yasson.internal.unmarshaller.EmbeddedItem;
import org.eclipse.yasson.model.JsonBindingModel;

public class MapDeserializer<T extends Map<?, ?>>
extends AbstractContainerDeserializer<T>
implements EmbeddedItem {
    private final Type mapValueRuntimeType = this.getRuntimeType() instanceof ParameterizedType ? ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[1]) : Object.class;
    private final T instance = this.createInstance();
    private final JsonBindingModel model;

    protected MapDeserializer(DeserializerBuilder builder) {
        super(builder);
        this.model = new ContainerModel(this.mapValueRuntimeType, this.resolveContainerModelCustomization(this.mapValueRuntimeType, builder.getJsonbContext()));
    }

    private T createInstance() {
        Class<?> rawType = ReflectionUtils.getRawType(this.getRuntimeType());
        return (T)(rawType.isInterface() ? this.getMapImpl(rawType) : (Map)ReflectionUtils.createNoArgConstructorInstance(rawType));
    }

    private Map<Object, Object> getMapImpl(Class ifcType) {
        if (SortedMap.class.isAssignableFrom(ifcType)) {
            return new TreeMap<Object, Object>();
        }
        return new HashMap<Object, Object>();
    }

    @Override
    protected JsonBindingModel getModel() {
        return this.model;
    }

    @Override
    public T getInstance(Unmarshaller unmarshaller) {
        return this.instance;
    }

    @Override
    public void appendResult(Object result) {
        this.appendCaptor(this.parserContext.getLastKeyName(), this.convertNullToOptionalEmpty(this.getModel(), result));
    }

    private <V> void appendCaptor(String key, V value) {
        this.getInstance(null).put(key, value);
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        JsonbDeserializer<?> deserializer = this.newCollectionOrMapItem(this.mapValueRuntimeType, context.getJsonbContext());
        this.appendResult(deserializer.deserialize(parser, (DeserializationContext)context, this.mapValueRuntimeType));
    }

    @Override
    protected JsonbRiParser.LevelContext moveToFirst(JsonbParser parser) {
        parser.moveTo(JsonParser.Event.START_OBJECT);
        return parser.getCurrentLevel();
    }
}

