/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.unmarshaller;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public class ResolvedParameterizedType
implements ParameterizedType {
    private final ParameterizedType original;
    private final Type[] resolvedTypeArgs;

    public ResolvedParameterizedType(ParameterizedType original, Type[] resolvedTypeArgs) {
        this.original = original;
        this.resolvedTypeArgs = resolvedTypeArgs;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.resolvedTypeArgs;
    }

    @Override
    public Type getRawType() {
        return this.original.getRawType();
    }

    @Override
    public Type getOwnerType() {
        return this.original.getOwnerType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.original.toString());
        if (this.resolvedTypeArgs != null && this.resolvedTypeArgs.length > 0) {
            sb.append(" resolved arguments: [");
            for (Type typeArg : this.resolvedTypeArgs) {
                sb.append(String.valueOf(typeArg));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType that = (ParameterizedType)o;
        return this.getRawType().equals(that.getRawType()) && Objects.equals(this.getOwnerType(), that.getOwnerType()) && Arrays.equals(this.resolvedTypeArgs, that.getActualTypeArguments());
    }

    public int hashCode() {
        return Arrays.hashCode(this.resolvedTypeArgs) ^ (this.getOwnerType() == null ? 0 : this.getOwnerType().hashCode()) ^ (this.getRawType() == null ? 0 : this.getRawType().hashCode());
    }
}

