/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.model;

import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.json.bind.config.PropertyNamingStrategy;
import javax.json.bind.serializer.JsonbSerializer;
import org.eclipse.yasson.internal.AnnotationIntrospector;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.adapter.AdapterBinding;
import org.eclipse.yasson.internal.adapter.SerializerBinding;
import org.eclipse.yasson.internal.serializer.AdaptedObjectSerializer;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;
import org.eclipse.yasson.internal.serializer.SerializerProviderWrapper;
import org.eclipse.yasson.internal.serializer.UserSerializerSerializer;
import org.eclipse.yasson.model.AnnotationTarget;
import org.eclipse.yasson.model.ClassModel;
import org.eclipse.yasson.model.JsonBindingModel;
import org.eclipse.yasson.model.JsonContext;
import org.eclipse.yasson.model.Property;
import org.eclipse.yasson.model.PropertyValuePropagation;
import org.eclipse.yasson.model.customization.PropertyCustomization;
import org.eclipse.yasson.model.customization.PropertyCustomizationBuilder;

public class PropertyModel
implements JsonBindingModel,
Comparable<PropertyModel> {
    private final String propertyName;
    private final String readName;
    private final String writeName;
    private final Type propertyType;
    private final ClassModel classModel;
    private final PropertyCustomization customization;
    private final PropertyValuePropagation propagation;
    private final JsonbSerializer<?> propertySerializer;

    public PropertyModel(ClassModel classModel, Property property, JsonbContext jsonbContext) {
        this.classModel = classModel;
        this.propertyName = property.getName();
        this.propertyType = property.getPropertyType();
        this.propagation = PropertyValuePropagation.createInstance(property, jsonbContext);
        this.customization = this.introspectCustomization(property, jsonbContext);
        this.readName = this.calculateReadWriteName(this.customization.getJsonReadName(), jsonbContext.getConfigProperties().getPropertyNamingStrategy());
        this.writeName = this.calculateReadWriteName(this.customization.getJsonWriteName(), jsonbContext.getConfigProperties().getPropertyNamingStrategy());
        this.propertySerializer = this.resolveCachedSerializer();
    }

    private JsonbSerializer<?> resolveCachedSerializer() {
        if (!ReflectionUtils.isResolvedType(this.propertyType)) {
            return null;
        }
        if (this.customization.getAdapterBinding() != null) {
            return new AdaptedObjectSerializer(this, this.customization.getAdapterBinding());
        }
        if (this.customization.getSerializerBinding() != null) {
            return new UserSerializerSerializer(this, this.customization.getSerializerBinding().getJsonbSerializer());
        }
        Class<?> propertyRawType = ReflectionUtils.getRawType(this.propertyType);
        Optional<SerializerProviderWrapper> valueSerializerProvider = DefaultSerializers.getInstance().findValueSerializerProvider(propertyRawType);
        if (valueSerializerProvider.isPresent()) {
            return valueSerializerProvider.get().getSerializerProvider().provideSerializer(this);
        }
        return null;
    }

    private AdapterBinding getUserAdapterBinding(Property property, JsonbContext jsonbContext) {
        AdapterBinding adapterBinding = jsonbContext.getAnnotationIntrospector().getAdapterBinding(property);
        if (adapterBinding != null) {
            return adapterBinding;
        }
        return jsonbContext.getComponentMatcher().getAdapterBinding(this.propertyType, null).orElse(null);
    }

    private SerializerBinding<?> getUserSerializerBinding(Property property, JsonbContext jsonbContext) {
        SerializerBinding serializerBinding = jsonbContext.getAnnotationIntrospector().getSerializerBinding(property);
        if (serializerBinding != null) {
            return serializerBinding;
        }
        return jsonbContext.getComponentMatcher().getSerializerBinding(this.propertyType, null).orElse(null);
    }

    private PropertyCustomization introspectCustomization(Property property, JsonbContext jsonbContext) {
        AnnotationIntrospector introspector = jsonbContext.getAnnotationIntrospector();
        PropertyCustomizationBuilder builder = new PropertyCustomizationBuilder();
        EnumSet<AnnotationTarget> transientInfo = introspector.getJsonbTransientCategorized(property);
        if (transientInfo.size() != 0) {
            builder.setReadTransient(transientInfo.contains((Object)AnnotationTarget.GETTER));
            builder.setWriteTransient(transientInfo.contains((Object)AnnotationTarget.SETTER));
            if (transientInfo.contains((Object)AnnotationTarget.PROPERTY)) {
                if (!transientInfo.contains((Object)AnnotationTarget.GETTER)) {
                    builder.setReadTransient(true);
                }
                if (!transientInfo.contains((Object)AnnotationTarget.SETTER)) {
                    builder.setWriteTransient(true);
                }
            }
        }
        if (!builder.isReadTransient()) {
            builder.setJsonWriteName(introspector.getJsonbPropertyJsonWriteName(property));
            builder.setNillable(introspector.isPropertyNillable(property).orElse(this.classModel.getClassCustomization().isNillable()));
            builder.setSerializerBinding(this.getUserSerializerBinding(property, jsonbContext));
        }
        if (!builder.isWriteTransient()) {
            builder.setJsonReadName(introspector.getJsonbPropertyJsonReadName(property));
            builder.setDeserializerBinding(introspector.getDeserializerBinding(property));
        }
        builder.setAdapterInfo(this.getUserAdapterBinding(property, jsonbContext));
        this.introspectDateFormatter(property, introspector, builder, jsonbContext);
        this.introspectNumberFormatter(property, introspector, builder);
        return builder.buildPropertyCustomization();
    }

    private void introspectDateFormatter(Property property, AnnotationIntrospector introspector, PropertyCustomizationBuilder builder, JsonbContext jsonbContext) {
        JsonbDateFormatter dateFormatter;
        Map<AnnotationTarget, JsonbDateFormatter> jsonDateFormatCategorized = introspector.getJsonbDateFormatCategorized(property);
        JsonbDateFormatter configDateFormatter = jsonbContext.getConfigProperties().getConfigDateFormatter();
        if (!builder.isReadTransient()) {
            dateFormatter = this.getTargetForMostPreciseScope(jsonDateFormatCategorized, AnnotationTarget.GETTER, AnnotationTarget.PROPERTY, AnnotationTarget.CLASS);
            builder.setSerializeDateFormatter(dateFormatter != null ? dateFormatter : configDateFormatter);
        }
        if (!builder.isWriteTransient()) {
            dateFormatter = this.getTargetForMostPreciseScope(jsonDateFormatCategorized, AnnotationTarget.SETTER, AnnotationTarget.PROPERTY, AnnotationTarget.CLASS);
            builder.setDeserializeDateFormatter(dateFormatter != null ? dateFormatter : configDateFormatter);
        }
    }

    private void introspectNumberFormatter(Property property, AnnotationIntrospector introspector, PropertyCustomizationBuilder builder) {
        Map<AnnotationTarget, JsonbNumberFormatter> jsonNumberFormatCategorized = introspector.getJsonNumberFormatter(property);
        if (!builder.isReadTransient()) {
            builder.setSerializeNumberFormatter(this.getTargetForMostPreciseScope(jsonNumberFormatCategorized, AnnotationTarget.GETTER, AnnotationTarget.PROPERTY, AnnotationTarget.CLASS));
        }
        if (!builder.isWriteTransient()) {
            builder.setDeserializeNumberFormatter(this.getTargetForMostPreciseScope(jsonNumberFormatCategorized, AnnotationTarget.SETTER, AnnotationTarget.PROPERTY, AnnotationTarget.CLASS));
        }
    }

    private <T> T getTargetForMostPreciseScope(Map<AnnotationTarget, T> collectedAnnotations, AnnotationTarget ... targets) {
        for (AnnotationTarget target : targets) {
            T result = collectedAnnotations.get((Object)target);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object getValue(Object object) {
        if (!this.isReadable()) {
            return null;
        }
        return this.propagation.getValue(object);
    }

    public void setValue(Object object, Object value) {
        if (!this.isWritable()) {
            return;
        }
        this.propagation.setValue(object, value);
    }

    public boolean isReadable() {
        return !this.customization.isReadTransient() && this.propagation.isReadable();
    }

    public boolean isWritable() {
        return !this.customization.isWriteTransient() && this.propagation.isWritable();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Type getPropertyType() {
        return this.propertyType;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    @Override
    public PropertyCustomization getCustomization() {
        return this.customization;
    }

    @Override
    public Type getType() {
        return this.getPropertyType();
    }

    @Override
    public int compareTo(PropertyModel o) {
        return this.propertyName.compareTo(o.getPropertyName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyModel that = (PropertyModel)o;
        return Objects.equals(this.propertyName, that.propertyName);
    }

    public int hashCode() {
        return Objects.hash(this.propertyName);
    }

    @Override
    public JsonContext getContext() {
        return JsonContext.JSON_OBJECT;
    }

    public String getReadName() {
        return this.readName;
    }

    @Override
    public String getWriteName() {
        return this.writeName;
    }

    public JsonbSerializer<?> getPropertySerializer() {
        return this.propertySerializer;
    }

    private String calculateReadWriteName(String readWriteName, PropertyNamingStrategy strategy) {
        return readWriteName != null ? readWriteName : strategy.translateName(this.propertyName);
    }

    public PropertyValuePropagation getPropagation() {
        return this.propagation;
    }
}

