/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal.xml;

import jakarta.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import org.ehcache.core.util.ClassLoading;
import org.ehcache.transactions.xa.internal.TypeUtil;
import org.ehcache.transactions.xa.txmgr.provider.LookupTransactionManagerProviderConfiguration;
import org.ehcache.transactions.xa.txmgr.provider.TransactionManagerProvider;
import org.ehcache.xml.BaseConfigParser;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.ParsingUtil;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class TxCacheManagerServiceConfigurationParser
extends BaseConfigParser<LookupTransactionManagerProviderConfiguration>
implements CacheManagerServiceConfigurationParser<TransactionManagerProvider<TransactionManager>, LookupTransactionManagerProviderConfiguration> {
    private static final String NAMESPACE = "http://www.ehcache.org/v3/tx";
    public static final String TRANSACTION_NAMESPACE_PREFIX = "tx:";
    private static final String TRANSACTION_ELEMENT_NAME = "jta-tm";
    private static final String TRANSACTION_LOOKUP_CLASS = "transaction-manager-lookup-class";

    public TxCacheManagerServiceConfigurationParser() {
        super(Collections.singletonMap(URI.create(NAMESPACE), TxCacheManagerServiceConfigurationParser.class.getResource("/ehcache-tx-ext.xsd")));
    }

    public LookupTransactionManagerProviderConfiguration parse(Element fragment, ClassLoader classLoader) {
        String localName = fragment.getLocalName();
        if (TRANSACTION_ELEMENT_NAME.equals(localName)) {
            String transactionManagerProviderConfigurationClassName = ParsingUtil.parsePropertyOrString((String)fragment.getAttribute(TRANSACTION_LOOKUP_CLASS));
            try {
                Class<?> aClass = Class.forName(transactionManagerProviderConfigurationClassName, true, ClassLoading.delegationChain(() -> Thread.currentThread().getContextClassLoader(), (ClassLoader[])new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader(), classLoader}));
                Class clazz = (Class)TypeUtil.uncheckedCast(aClass);
                return new LookupTransactionManagerProviderConfiguration(clazz);
            }
            catch (Exception e) {
                throw new XmlConfigurationException("Error configuring XA transaction manager", (Throwable)e);
            }
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<TransactionManagerProvider<TransactionManager>> getServiceType() {
        return (Class)TypeUtil.uncheckedCast(TransactionManagerProvider.class);
    }

    public Element safeUnparse(Document doc, LookupTransactionManagerProviderConfiguration lookupTransactionManagerProviderConfiguration) {
        Element rootElement = doc.createElementNS(NAMESPACE, "tx:jta-tm");
        rootElement.setAttribute(TRANSACTION_LOOKUP_CLASS, lookupTransactionManagerProviderConfiguration.getTransactionManagerLookup().getName());
        return rootElement;
    }
}

