/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jdk;

import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ModuleQualifiedExportsService {
    protected final Module selfModule = this.getClass().getModule();
    private final Map<String, List<String>> qualifiedExports = this.invert(this.selfModule.getDescriptor().exports(), ModuleDescriptor.Exports::isQualified, ModuleDescriptor.Exports::source, ModuleDescriptor.Exports::targets);
    private final Map<String, List<String>> qualifiedOpens = this.invert(this.selfModule.getDescriptor().opens(), ModuleDescriptor.Opens::isQualified, ModuleDescriptor.Opens::source, ModuleDescriptor.Opens::targets);
    private final Set<String> targets = Stream.concat(this.qualifiedExports.keySet().stream(), this.qualifiedOpens.keySet().stream()).collect(Collectors.toUnmodifiableSet());

    protected ModuleQualifiedExportsService() {
    }

    private <T> Map<String, List<String>> invert(Collection<T> sourcesToTargets, Predicate<T> qualifiedPredicate, Function<T, String> sourceGetter, Function<T, Collection<String>> targetsGetter) {
        HashMap<String, List> targetsToSources = new HashMap<String, List>();
        for (T sourceToTargets : sourcesToTargets) {
            if (!qualifiedPredicate.test(sourceToTargets)) continue;
            String source = sourceGetter.apply(sourceToTargets);
            Collection<String> targets = targetsGetter.apply(sourceToTargets);
            for (String target : targets) {
                targetsToSources.computeIfAbsent(target, k -> new ArrayList()).add(source);
            }
        }
        return Map.copyOf(targetsToSources);
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public void addExportsAndOpens(Module target) {
        String targetName = target.getName();
        if (!this.targets.contains(targetName)) {
            throw new IllegalArgumentException("Module " + this.selfModule.getName() + " does not contain qualified exports or opens for module " + targetName);
        }
        List exports = this.qualifiedExports.getOrDefault(targetName, List.of());
        for (String export : exports) {
            this.addExports(export, target);
        }
        List opens = this.qualifiedOpens.getOrDefault(targetName, List.of());
        for (String open : opens) {
            this.addOpens(open, target);
        }
    }

    protected abstract void addExports(String var1, Module var2);

    protected abstract void addOpens(String var1, Module var2);
}

