/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eluder.coveralls.maven.plugin.domain.JsonObject;

public final class Source
implements JsonObject {
    private static final Pattern NEWLINE = Pattern.compile("\r\n|\r|\n");
    private final String name;
    private final String source;
    private final Integer[] coverage;
    private String classifier;

    public Source(String name, String source) {
        int lines = 1;
        StringBuffer replaced = new StringBuffer(source.length());
        Matcher matcher = NEWLINE.matcher(source);
        while (matcher.find()) {
            ++lines;
            matcher.appendReplacement(replaced, "\n");
        }
        matcher.appendTail(replaced);
        this.source = replaced.toString();
        this.coverage = new Integer[lines];
        this.name = name;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public String getFullName() {
        return this.name;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="coverage")
    public Integer[] getCoverage() {
        return this.coverage;
    }

    @JsonIgnore
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void addCoverage(int lineNumber, Integer coverage) {
        this.coverage[lineNumber - 1] = coverage;
    }
}

