/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.parser;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.parser.AbstractXmlEventParser;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;
import org.eluder.coveralls.maven.plugin.source.SourceLoader;

public class JaCoCoParser
extends AbstractXmlEventParser {
    private String packageName;
    private Source source;

    public JaCoCoParser(File coverageFile, SourceLoader sourceLoader) {
        super(coverageFile, sourceLoader);
    }

    @Override
    protected void onEvent(XMLStreamReader xml, SourceCallback callback) throws XMLStreamException, ProcessingException, IOException {
        if (this.isStartElement(xml, "package")) {
            this.packageName = xml.getAttributeValue(null, "name");
        } else if (this.isStartElement(xml, "sourcefile") && this.packageName != null) {
            String sourceFile = this.packageName + "/" + xml.getAttributeValue(null, "name");
            this.source = this.loadSource(sourceFile);
        } else if (this.isStartElement(xml, "line") && this.source != null) {
            int ci = Integer.parseInt(xml.getAttributeValue(null, "ci"));
            this.source.addCoverage(Integer.parseInt(xml.getAttributeValue(null, "nr")), ci == 0 ? 0 : 1);
        } else if (this.isEndElement(xml, "sourcefile") && this.source != null) {
            callback.onSource(this.source);
            this.source = null;
        } else if (this.isEndElement(xml, "package")) {
            this.packageName = null;
        }
    }
}

