/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.util;

import java.io.File;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eluder.coveralls.maven.plugin.source.DirectorySourceLoader;
import org.eluder.coveralls.maven.plugin.source.MultiSourceLoader;
import org.eluder.coveralls.maven.plugin.source.SourceLoader;
import org.eluder.coveralls.maven.plugin.util.MavenProjectCollector;

public class SourceLoaderFactory {
    private final File baseDir;
    private final MavenProject project;
    private final String sourceEncoding;
    private List<File> sourceDirectories;

    public SourceLoaderFactory(File baseDir, MavenProject project, String sourceEncoding) {
        this.baseDir = baseDir;
        this.project = project;
        this.sourceEncoding = sourceEncoding;
    }

    public SourceLoaderFactory withSourceDirectories(List<File> sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
        return this;
    }

    public SourceLoader createSourceLoader() {
        MultiSourceLoader multiSourceLoader = new MultiSourceLoader();
        List<MavenProject> modules = new MavenProjectCollector(this.project).collect();
        for (MavenProject module : modules) {
            for (String sourceRoot : module.getCompileSourceRoots()) {
                File sourceDirectory = new File(sourceRoot);
                if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) continue;
                DirectorySourceLoader moduleSourceLoader = new DirectorySourceLoader(this.baseDir, sourceDirectory, this.sourceEncoding);
                multiSourceLoader.add(moduleSourceLoader);
            }
        }
        if (this.sourceDirectories != null) {
            for (File sourceDirectory : this.sourceDirectories) {
                if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) continue;
                DirectorySourceLoader moduleSourceLoader = new DirectorySourceLoader(this.baseDir, sourceDirectory, this.sourceEncoding);
                multiSourceLoader.add(moduleSourceLoader);
            }
        }
        return multiSourceLoader;
    }
}

