/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.eluder.coveralls.maven.plugin.domain.Job;
import org.eluder.coveralls.maven.plugin.validation.ValidationError;
import org.eluder.coveralls.maven.plugin.validation.ValidationErrors;

public class JobValidator {
    private final Job job;

    public JobValidator(Job job) {
        if (job == null) {
            throw new IllegalArgumentException("job must be defined");
        }
        this.job = job;
    }

    public ValidationErrors validate() {
        ValidationErrors errors = new ValidationErrors();
        errors.addAll(this.repoTokenOrTravis());
        errors.addAll(this.git());
        return errors;
    }

    private List<ValidationError> repoTokenOrTravis() {
        if (this.hasValue(this.job.getRepoToken())) {
            return Collections.emptyList();
        }
        if (this.hasValue(this.job.getServiceName()) && this.hasValue(this.job.getServiceJobId())) {
            return Collections.emptyList();
        }
        ValidationError.Level level = this.job.isDryRun() ? ValidationError.Level.WARN : ValidationError.Level.ERROR;
        String message = "Either repository token or service with job id must be defined";
        return Arrays.asList(new ValidationError(level, message));
    }

    private List<ValidationError> git() {
        if (this.job.getGit() == null) {
            return Collections.emptyList();
        }
        if (this.hasValue(this.job.getGit().getHead().getId())) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ValidationError(ValidationError.Level.ERROR, "Commit id for HEAD must be defined"));
    }

    private boolean hasValue(String value) {
        return StringUtils.isNotBlank((String)value);
    }
}

