/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.assured;

import java.security.Principal;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.everrest.assured.AvailablePortFinder;
import org.everrest.core.DependencySupplier;
import org.everrest.core.ObjectFactory;
import org.everrest.core.RequestHandler;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.impl.RequestHandlerImpl;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.servlet.EverrestInitializedListener;
import org.everrest.core.servlet.EverrestServlet;
import org.everrest.core.tools.DummySecurityContext;
import org.everrest.core.tools.ResourceLauncher;
import org.everrest.test.mock.MockPrincipal;

public class JettyHttpServer {
    protected ServletContextHandler context;
    protected final int port;
    protected final Server server;
    public static final String ADMIN_USER_NAME = "cldadmin";
    public static final String ADMIN_USER_PASSWORD = "tomcat";
    public static final String MANAGER_USER_NAME = "cldmanager";
    public static final String MANAGER_USER_PASSWORD = "manager";
    public static final String UNAUTHORIZED_USER = "user";
    private List<Object> restServices;

    public JettyHttpServer() {
        this(AvailablePortFinder.getNextAvailable(3000));
    }

    public JettyHttpServer(int port) {
        this.port = port;
        this.server = new Server(port);
        this.context = null;
    }

    public int getPort() {
        return this.port;
    }

    public void start() {
        RequestLogHandler handler = new RequestLogHandler();
        if (this.context == null) {
            this.context = new ServletContextHandler((HandlerContainer)handler, this.getContextPath(), 1);
        }
        this.context.setEventListeners(this.getEventListeners());
        ServletHolder servletHolder = new ServletHolder((Servlet)new EverrestServlet());
        this.initParams(this.context.getInitParams());
        this.context.addServlet(servletHolder, "/rest/*");
        this.context.addServlet(servletHolder, "/rest/private/*");
        this.setContextAttributes(this.context);
        SecurityHandler securityHandler = this.getSecurityHandler();
        if (securityHandler != null) {
            this.context.setSecurityHandler(securityHandler);
        }
        this.server.setHandler((Handler)handler);
        try {
            this.server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public void setFactories(List<ObjectFactory<AbstractResourceDescriptor>> factories) {
        ResourceBinder binder = (ResourceBinder)this.context.getServletContext().getAttribute(ResourceBinder.class.getName());
        for (ObjectFactory<AbstractResourceDescriptor> resource : factories) {
            binder.addResource(resource);
        }
    }

    public void resetFactories() {
        ResourceBinder binder = (ResourceBinder)this.context.getServletContext().getAttribute(ResourceBinder.class.getName());
        ((ResourceBinderImpl)binder).clear();
    }

    public ResourceLauncher getResourceLauncher() {
        ResourceBinder binder = (ResourceBinder)this.context.getServletContext().getAttribute(ResourceBinder.class.getName());
        DependencySupplier suppier = (DependencySupplier)this.context.getServletContext().getAttribute(DependencySupplier.class.getName());
        ApplicationProviderBinder providerBinder = (ApplicationProviderBinder)this.context.getServletContext().getAttribute(ApplicationProviderBinder.class.getName());
        return new ResourceLauncher((RequestHandler)new RequestHandlerImpl(new RequestDispatcher(binder), (ProviderBinder)providerBinder, suppier, new EverrestConfiguration()));
    }

    public void stop() {
        this.context = null;
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    protected String getContextPath() {
        return "/";
    }

    protected void setContextAttributes(ServletContextHandler context) {
    }

    protected EventListener[] getEventListeners() {
        return new EventListener[]{new EverrestInitializedListener()};
    }

    protected SecurityHandler getSecurityHandler() {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"cloud-admin"});
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/" + this.getSecureRestPath() + "/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(constraintMapping);
        HashLoginService loginService = new HashLoginService();
        loginService.putUser(ADMIN_USER_NAME, (Credential)new Password(ADMIN_USER_PASSWORD), new String[]{"cloud-admin"});
        loginService.putUser(MANAGER_USER_NAME, (Credential)new Password(MANAGER_USER_PASSWORD), new String[]{"cloud-admin"});
        securityHandler.setLoginService((LoginService)loginService);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        return securityHandler;
    }

    protected String getSecureRestPath() {
        return "rest";
    }

    public String getRestUri(boolean secure) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("http://localhost:");
        buffer.append(this.port);
        buffer.append(this.getContextPath());
        if (secure) {
            buffer.append(this.getSecureRestPath());
        } else {
            buffer.append("rest");
        }
        return buffer.toString();
    }

    public String getRestUri() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("http://localhost:");
        buffer.append(this.port);
        buffer.append(this.getContextPath());
        buffer.append("rest");
        return buffer.toString();
    }

    protected void initParams(Map<String, String> params) {
    }

    public EnvironmentContext getUnsecureEnvironment() {
        MockPrincipal userPrincipal = new MockPrincipal(UNAUTHORIZED_USER);
        HashSet<String> userRoles = new HashSet<String>();
        userRoles.add("users");
        DummySecurityContext userSctx = new DummySecurityContext((Principal)userPrincipal, userRoles);
        EnvironmentContext unsecureEnvironment = new EnvironmentContext();
        unsecureEnvironment.put(SecurityContext.class, (Object)userSctx);
        return unsecureEnvironment;
    }

    public EnvironmentContext getSecureEnvironment() {
        MockPrincipal adminPrincipal = new MockPrincipal(ADMIN_USER_NAME);
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("users");
        adminRoles.add("cloud-admin");
        DummySecurityContext adminSctx = new DummySecurityContext((Principal)adminPrincipal, adminRoles);
        EnvironmentContext secureEnvironment = new EnvironmentContext();
        secureEnvironment.put(SecurityContext.class, (Object)adminSctx);
        return secureEnvironment;
    }
}

