/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.assured.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IoUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResource(String resourceName) {
        InputStream stream = null;
        try {
            int read;
            File file = new File(resourceName);
            stream = file.isFile() && file.exists() ? new FileInputStream(file) : Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return "";
    }
}

