/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.ConstructorDescriptor;
import org.everrest.core.FieldInjector;
import org.everrest.core.ObjectModel;
import org.everrest.core.impl.ConstructorDescriptorImpl;
import org.everrest.core.impl.FieldInjectorImpl;
import org.everrest.core.impl.MultivaluedMapImpl;

public abstract class BaseObjectModel
implements ObjectModel {
    protected final Class<?> clazz;
    protected MultivaluedMapImpl properties;
    protected final List<ConstructorDescriptor> constructors;
    protected final List<FieldInjector> fields;

    public BaseObjectModel(Class<?> clazz, ComponentLifecycleScope scope) {
        this.clazz = clazz;
        this.constructors = new ArrayList<ConstructorDescriptor>();
        this.fields = new ArrayList<FieldInjector>();
        if (scope == ComponentLifecycleScope.PER_REQUEST) {
            String resourcePackageName;
            for (Constructor<?> constructor : clazz.getConstructors()) {
                this.constructors.add(new ConstructorDescriptorImpl(clazz, constructor));
            }
            if (this.constructors.size() == 0) {
                String msg = "Not found accepted constructors for provider class " + clazz.getName();
                throw new RuntimeException(msg);
            }
            if (this.constructors.size() > 1) {
                Collections.sort(this.constructors, ConstructorDescriptorImpl.CONSTRUCTOR_COMPARATOR);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                this.fields.add(new FieldInjectorImpl(clazz, (Field)accessibleObject));
            }
            Package _package = clazz.getPackage();
            String string = resourcePackageName = _package != null ? _package.getName() : null;
            for (Class<?> sc = clazz.getSuperclass(); sc != Object.class; sc = sc.getSuperclass()) {
                for (Field jfield : sc.getDeclaredFields()) {
                    FieldInjectorImpl inj;
                    String scPackageName;
                    int modif = jfield.getModifiers();
                    Package package1 = clazz.getPackage();
                    String string2 = scPackageName = package1 != null ? package1.getName() : null;
                    if (Modifier.isPrivate(modif) || !Modifier.isPublic(modif) && !Modifier.isProtected(modif) && (Modifier.isPrivate(modif) || (resourcePackageName != null || scPackageName != null) && !resourcePackageName.equals(scPackageName)) || (inj = new FieldInjectorImpl(clazz, jfield)).getAnnotation() == null) continue;
                    this.fields.add(new FieldInjectorImpl(clazz, jfield));
                }
            }
        }
    }

    @Override
    public Class<?> getObjectClass() {
        return this.clazz;
    }

    @Override
    public List<ConstructorDescriptor> getConstructorDescriptors() {
        return this.constructors;
    }

    @Override
    public List<FieldInjector> getFieldInjectors() {
        return this.fields;
    }

    @Override
    public MultivaluedMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new MultivaluedMapImpl();
        }
        return this.properties;
    }

    @Override
    public List<String> getProperty(String key) {
        if (this.properties != null) {
            return (List)this.properties.get(key);
        }
        return null;
    }
}

