/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.IOException;
import javax.ws.rs.core.Application;
import org.everrest.core.DependencySupplier;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.RequestHandler;
import org.everrest.core.ResourceBinder;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ApplicationPublisher;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.impl.RequestHandlerImpl;

public final class EverrestProcessor {
    private final RequestHandler requestHandler;
    private final ResourceBinder resources;
    private final ProviderBinder providers;

    public EverrestProcessor(ResourceBinder resources, ProviderBinder providers, DependencySupplier dependencies, EverrestConfiguration config, Application application) {
        this.resources = resources;
        this.providers = providers;
        this.requestHandler = new RequestHandlerImpl(providers, new RequestDispatcher(resources), dependencies, config);
        this.addApplication(application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GenericContainerRequest request, GenericContainerResponse response, EnvironmentContext envCtx) throws UnhandledException, IOException {
        try {
            EnvironmentContext.setCurrent(envCtx);
            this.requestHandler.handleRequest(request, response);
        }
        finally {
            EnvironmentContext.setCurrent(null);
        }
    }

    public void addApplication(Application application) {
        if (application != null) {
            ApplicationPublisher appPublisher = new ApplicationPublisher(this.resources, this.providers);
            appPublisher.publish(application);
        }
    }
}

