/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.FieldInjector;
import org.everrest.core.impl.method.ParameterHelper;
import org.everrest.core.impl.method.ParameterResolver;
import org.everrest.core.impl.method.ParameterResolverFactory;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.util.Logger;

public class FieldInjectorImpl
implements FieldInjector {
    private static final Logger LOG = Logger.getLogger(FieldInjectorImpl.class);
    private final Annotation[] annotations;
    private final Annotation annotation;
    private final String defaultValue;
    private final boolean encoded;
    private final Field jfield;

    public FieldInjectorImpl(Class<?> resourceClass, Field jfield) {
        this.jfield = jfield;
        this.annotations = jfield.getDeclaredAnnotations();
        Annotation annotation = null;
        String defaultValue = null;
        boolean encoded = false;
        boolean provider = resourceClass.getAnnotation(Provider.class) != null;
        List<String> allowedAnnotation = provider ? ParameterHelper.PROVIDER_FIELDS_ANNOTATIONS : ParameterHelper.RESOURCE_FIELDS_ANNOTATIONS;
        for (Annotation a : this.annotations) {
            Class<? extends Annotation> ac = a.annotationType();
            if (allowedAnnotation.contains(ac.getName())) {
                if (annotation == null) {
                    annotation = a;
                    continue;
                }
                String msg = "JAX-RS annotations on one of fields " + jfield.toString() + " are equivocality. Annotations: " + ((Object)annotation).toString() + " and " + ((Object)a).toString() + " can't be applied to one field.";
                throw new RuntimeException(msg);
            }
            if (ac == Encoded.class && !provider) {
                encoded = true;
                continue;
            }
            if (ac == DefaultValue.class && !provider) {
                defaultValue = ((DefaultValue)a).value();
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.warn("Field " + jfield.toString() + " contains unknown or not allowed JAX-RS annotation " + ((Object)a).toString() + ". It will be ignored.");
        }
        this.defaultValue = defaultValue;
        this.annotation = annotation;
        this.encoded = encoded || resourceClass.getAnnotation(Encoded.class) != null;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class<?> getParameterClass() {
        return this.jfield.getType();
    }

    @Override
    public Type getGenericType() {
        return this.jfield.getGenericType();
    }

    @Override
    public boolean isEncoded() {
        return this.encoded;
    }

    @Override
    public String getName() {
        return this.jfield.getName();
    }

    @Override
    public void inject(Object resource, ApplicationContext context) {
        Object tmp;
        if (this.annotation != null) {
            ParameterResolver pr = ParameterResolverFactory.createParameterResolver(this.annotation);
            try {
                if (!Modifier.isPublic(this.jfield.getModifiers())) {
                    this.jfield.setAccessible(true);
                }
                this.jfield.set(resource, pr.resolve(this, context));
            }
            catch (Throwable e) {
                Class<? extends Annotation> ac = this.annotation.annotationType();
                if (ac == MatrixParam.class || ac == QueryParam.class || ac == PathParam.class) {
                    throw new WebApplicationException(e, Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                }
                throw new WebApplicationException(e, Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            }
        }
        if (context.getDependencySupplier() != null && (tmp = context.getDependencySupplier().getComponent(this)) != null) {
            try {
                if (!Modifier.isPublic(this.jfield.getModifiers())) {
                    this.jfield.setAccessible(true);
                }
                this.jfield.set(resource, tmp);
            }
            catch (Throwable e) {
                throw new WebApplicationException(e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
            }
        }
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitFieldInjector(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ FieldInjectorImpl: ");
        sb.append("annotation: " + this.getAnnotation()).append("; type: " + this.getParameterClass()).append("; generic-type : " + this.getGenericType()).append("; default-value: " + this.getDefaultValue()).append("; encoded: " + this.isEncoded()).append(" ]");
        return sb.toString();
    }
}

