/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.FilterDescriptor;
import org.everrest.core.ObjectFactory;
import org.everrest.core.PerRequestObjectFactory;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResponseFilter;
import org.everrest.core.SingletonObjectFactory;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.FilterDescriptorImpl;
import org.everrest.core.impl.header.MediaTypeHelper;
import org.everrest.core.impl.provider.ByteEntityProvider;
import org.everrest.core.impl.provider.DOMSourceEntityProvider;
import org.everrest.core.impl.provider.DataSourceEntityProvider;
import org.everrest.core.impl.provider.DefaultExceptionMapper;
import org.everrest.core.impl.provider.FileEntityProvider;
import org.everrest.core.impl.provider.InputStreamEntityProvider;
import org.everrest.core.impl.provider.JAXBContextResolver;
import org.everrest.core.impl.provider.JAXBElementEntityProvider;
import org.everrest.core.impl.provider.JAXBObjectEntityProvider;
import org.everrest.core.impl.provider.JsonEntityProvider;
import org.everrest.core.impl.provider.MultipartFormDataEntityProvider;
import org.everrest.core.impl.provider.MultivaluedMapEntityProvider;
import org.everrest.core.impl.provider.ProviderDescriptorImpl;
import org.everrest.core.impl.provider.ReaderEntityProvider;
import org.everrest.core.impl.provider.SAXSourceEntityProvider;
import org.everrest.core.impl.provider.StreamOutputEntityProvider;
import org.everrest.core.impl.provider.StreamSourceEntityProvider;
import org.everrest.core.impl.provider.StringEntityProvider;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.method.MethodInvokerFilter;
import org.everrest.core.provider.ProviderDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.uri.UriPattern;
import org.everrest.core.util.Logger;
import org.everrest.core.util.MediaTypeMap;
import org.everrest.core.util.MediaTypeMultivaluedMap;
import org.everrest.core.util.UriPatternMap;

public class ProviderBinder
implements Providers {
    private static final Logger LOG = Logger.getLogger(ProviderBinder.class);
    private static final RuntimePermission PROVIDERS_PERMISSIONS = new RuntimePermission("providersManagePermission");
    private static AtomicReference<ProviderBinder> ainst = new AtomicReference();
    protected final MediaTypeMultivaluedMap<ObjectFactory<ProviderDescriptor>> writeProviders = new MediaTypeMultivaluedMap();
    protected final MediaTypeMultivaluedMap<ObjectFactory<ProviderDescriptor>> readProviders = new MediaTypeMultivaluedMap();
    protected final Map<Class<? extends Throwable>, ObjectFactory<ProviderDescriptor>> exceptionMappers = new HashMap<Class<? extends Throwable>, ObjectFactory<ProviderDescriptor>>();
    protected final Map<Class<?>, MediaTypeMap<ObjectFactory<ProviderDescriptor>>> contextResolvers = new HashMap();
    protected final UriPatternMap<ObjectFactory<FilterDescriptor>> requestFilters = new UriPatternMap();
    protected final UriPatternMap<ObjectFactory<FilterDescriptor>> responseFilters = new UriPatternMap();
    protected final UriPatternMap<ObjectFactory<FilterDescriptor>> invokerFilters = new UriPatternMap();
    protected final ResourceDescriptorVisitor rdv = ResourceDescriptorValidator.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProviderBinder getInstance() {
        ProviderBinder t = ainst.get();
        if (t != null) {
            return t;
        }
        AtomicReference<ProviderBinder> atomicReference = ainst;
        synchronized (atomicReference) {
            t = ainst.get();
            if (t != null) {
                return t;
            }
            t = new ProviderBinder();
            ainst.compareAndSet(null, t);
        }
        return ainst.get();
    }

    public static void setInstance(ProviderBinder inst) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(PROVIDERS_PERMISSIONS);
        }
        ainst.set(inst);
    }

    protected ProviderBinder() {
        this.init();
    }

    public void addContextResolver(Class<? extends ContextResolver> clazz) {
        try {
            ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz, ComponentLifecycleScope.PER_REQUEST);
            descriptor.accept(this.rdv);
            this.addContextResolver(new PerRequestObjectFactory<ProviderDescriptor>(descriptor));
        }
        catch (Exception e) {
            LOG.error("Failed add ContextResolver " + clazz.getName(), e);
        }
    }

    public void addContextResolver(ContextResolver instance) {
        Class<?> clazz = instance.getClass();
        try {
            ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz, ComponentLifecycleScope.SINGLETON);
            descriptor.accept(this.rdv);
            this.addContextResolver(new SingletonObjectFactory<ProviderDescriptor>(descriptor, instance));
        }
        catch (Exception e) {
            LOG.error("Failed add ContextResolver " + clazz.getName(), e);
        }
    }

    public void addExceptionMapper(Class<? extends ExceptionMapper> clazz) {
        try {
            this.addExceptionMapper(new PerRequestObjectFactory<ProviderDescriptor>(new ProviderDescriptorImpl(clazz, ComponentLifecycleScope.PER_REQUEST)));
        }
        catch (Exception e) {
            LOG.error("Failed add ExceptionMapper " + clazz.getName(), e);
        }
    }

    public void addExceptionMapper(ExceptionMapper instance) {
        Class<?> clazz = instance.getClass();
        try {
            this.addExceptionMapper(new SingletonObjectFactory<ProviderDescriptor>(new ProviderDescriptorImpl(clazz, ComponentLifecycleScope.SINGLETON), instance));
        }
        catch (Exception e) {
            LOG.error("Failed add ExceptionMapper " + clazz.getName(), e);
        }
    }

    public void addMessageBodyReader(Class<? extends MessageBodyReader> clazz) {
        try {
            ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz, ComponentLifecycleScope.PER_REQUEST);
            descriptor.accept(this.rdv);
            this.addMessageBodyReader(new PerRequestObjectFactory<ProviderDescriptor>(descriptor));
        }
        catch (Exception e) {
            LOG.error("Failed add MessageBodyReader " + clazz.getName(), e);
        }
    }

    public void addMessageBodyReader(MessageBodyReader instance) {
        Class<?> clazz = instance.getClass();
        try {
            ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz, ComponentLifecycleScope.SINGLETON);
            descriptor.accept(this.rdv);
            this.addMessageBodyReader(new SingletonObjectFactory<ProviderDescriptor>(descriptor, instance));
        }
        catch (Exception e) {
            LOG.error("Failed add MessageBodyReader " + clazz.getName(), e);
        }
    }

    public void addMessageBodyWriter(Class<? extends MessageBodyWriter> clazz) {
        try {
            ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz, ComponentLifecycleScope.PER_REQUEST);
            descriptor.accept(this.rdv);
            this.addMessageBodyWriter(new PerRequestObjectFactory<ProviderDescriptor>(descriptor));
        }
        catch (Exception e) {
            LOG.error("Failed add MessageBodyWriter " + clazz.getName(), e);
        }
    }

    public void addMessageBodyWriter(MessageBodyWriter instance) {
        Class<?> clazz = instance.getClass();
        try {
            ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz, ComponentLifecycleScope.SINGLETON);
            descriptor.accept(this.rdv);
            this.addMessageBodyWriter(new SingletonObjectFactory<ProviderDescriptor>(descriptor, instance));
        }
        catch (Exception e) {
            LOG.error("Failed add MessageBodyWriter " + clazz.getName(), e);
        }
    }

    public void addMethodInvokerFilter(Class<? extends MethodInvokerFilter> clazz) {
        try {
            FilterDescriptorImpl descriptor = new FilterDescriptorImpl(clazz, ComponentLifecycleScope.PER_REQUEST);
            descriptor.accept(this.rdv);
            this.addMethodInvokerFilter(new PerRequestObjectFactory<FilterDescriptor>(descriptor));
        }
        catch (Exception e) {
            LOG.error("Failed add MethodInvokerFilter " + clazz.getName(), e);
        }
    }

    public void addMethodInvokerFilter(MethodInvokerFilter instance) {
        Class<?> clazz = instance.getClass();
        try {
            FilterDescriptorImpl descriptor = new FilterDescriptorImpl(clazz, ComponentLifecycleScope.SINGLETON);
            descriptor.accept(this.rdv);
            this.addMethodInvokerFilter(new SingletonObjectFactory<FilterDescriptor>(descriptor, instance));
        }
        catch (Exception e) {
            LOG.error("Failed add RequestFilter " + clazz.getName(), e);
        }
    }

    public void addRequestFilter(Class<? extends RequestFilter> clazz) {
        try {
            FilterDescriptorImpl descriptor = new FilterDescriptorImpl(clazz, ComponentLifecycleScope.PER_REQUEST);
            descriptor.accept(this.rdv);
            this.addRequestFilter(new PerRequestObjectFactory<FilterDescriptor>(descriptor));
        }
        catch (Exception e) {
            LOG.error("Failed add MethodInvokerFilter " + clazz.getName(), e);
        }
    }

    public void addRequestFilter(RequestFilter instance) {
        Class<?> clazz = instance.getClass();
        try {
            FilterDescriptorImpl descriptor = new FilterDescriptorImpl(clazz, ComponentLifecycleScope.SINGLETON);
            descriptor.accept(this.rdv);
            this.addRequestFilter(new SingletonObjectFactory<FilterDescriptor>(descriptor, instance));
        }
        catch (Exception e) {
            LOG.error("Failed add RequestFilter " + clazz.getName(), e);
        }
    }

    public void addResponseFilter(Class<? extends ResponseFilter> clazz) {
        try {
            FilterDescriptorImpl descriptor = new FilterDescriptorImpl(clazz, ComponentLifecycleScope.PER_REQUEST);
            descriptor.accept(this.rdv);
            this.addResponseFilter(new PerRequestObjectFactory<FilterDescriptor>(descriptor));
        }
        catch (Exception e) {
            LOG.error("Failed add ResponseFilter " + clazz.getName(), e);
        }
    }

    public void addResponseFilter(ResponseFilter instance) {
        Class<?> clazz = instance.getClass();
        try {
            FilterDescriptorImpl descriptor = new FilterDescriptorImpl(clazz, ComponentLifecycleScope.SINGLETON);
            descriptor.accept(this.rdv);
            this.addResponseFilter(new SingletonObjectFactory<FilterDescriptor>(descriptor, instance));
        }
        catch (Exception e) {
            LOG.error("Failed add ResponseFilter " + clazz.getName(), e);
        }
    }

    public List<MediaType> getAcceptableWriterMediaTypes(Class<?> type, Type genericType, Annotation[] annotations) {
        return this.doGetAcceptableWriterMediaTypes(type, genericType, annotations);
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        return this.doGetContextResolver(contextType, mediaType);
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        return this.doGetExceptionMapper(type);
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.doGetMessageBodyReader(type, genericType, annotations, mediaType);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.doGetMessageBodyWriter(type, genericType, annotations, mediaType);
    }

    public List<ObjectFactory<FilterDescriptor>> getMethodInvokerFilters(String path) {
        return this.doGetMatchedFilters(path, this.invokerFilters);
    }

    public List<ObjectFactory<FilterDescriptor>> getRequestFilters(String path) {
        return this.doGetMatchedFilters(path, this.requestFilters);
    }

    public List<ObjectFactory<FilterDescriptor>> getResponseFilters(String path) {
        return this.doGetMatchedFilters(path, this.responseFilters);
    }

    public void addContextResolver(ObjectFactory<ProviderDescriptor> contextResolverFactory) {
        for (Type type : contextResolverFactory.getObjectModel().getObjectClass().getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || ContextResolver.class != (pt = (ParameterizedType)type).getRawType()) continue;
            Type[] atypes = pt.getActualTypeArguments();
            if (atypes.length > 1) {
                throw new RuntimeException("Unable strong determine actual type argument, more then one type found.");
            }
            Class aclazz = (Class)atypes[0];
            MediaTypeMap<ObjectFactory<ProviderDescriptor>> pm = this.contextResolvers.get(aclazz);
            if (pm == null) {
                pm = new MediaTypeMap();
                this.contextResolvers.put(aclazz, pm);
            }
            for (MediaType mime : contextResolverFactory.getObjectModel().produces()) {
                if (pm.get(mime) != null) {
                    throw new RuntimeException("ContextResolver for " + aclazz.getName() + " and media type " + mime + " already registered.");
                }
                pm.put(mime, contextResolverFactory);
            }
        }
    }

    public void addExceptionMapper(ObjectFactory<ProviderDescriptor> exceptionMapperFactory) {
        for (Type type : exceptionMapperFactory.getObjectModel().getObjectClass().getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || ExceptionMapper.class != (pt = (ParameterizedType)type).getRawType()) continue;
            Type[] atypes = pt.getActualTypeArguments();
            if (atypes.length > 1) {
                throw new RuntimeException("Unable strong determine actual type argument, more then one type found.");
            }
            Class exc = (Class)atypes[0];
            if (this.exceptionMappers.get(exc) != null) {
                throw new RuntimeException("ExceptionMapper for exception " + exc + " already registered.");
            }
            this.exceptionMappers.put(exc, exceptionMapperFactory);
        }
    }

    public void addMessageBodyReader(ObjectFactory<ProviderDescriptor> readerFactory) {
        for (MediaType mime : readerFactory.getObjectModel().consumes()) {
            this.readProviders.getList(mime).add(readerFactory);
        }
    }

    public void addMessageBodyWriter(ObjectFactory<ProviderDescriptor> writerFactory) {
        for (MediaType mime : writerFactory.getObjectModel().produces()) {
            this.writeProviders.getList(mime).add(writerFactory);
        }
    }

    public void addMethodInvokerFilter(ObjectFactory<FilterDescriptor> filterFactory) {
        this.invokerFilters.getList(filterFactory.getObjectModel().getUriPattern()).add(filterFactory);
    }

    public void addRequestFilter(ObjectFactory<FilterDescriptor> filterFactory) {
        this.requestFilters.getList(filterFactory.getObjectModel().getUriPattern()).add(filterFactory);
    }

    public void addResponseFilter(ObjectFactory<FilterDescriptor> filterFactory) {
        this.responseFilters.getList(filterFactory.getObjectModel().getUriPattern()).add(filterFactory);
    }

    protected List<MediaType> doGetAcceptableWriterMediaTypes(Class<?> type, Type genericType, Annotation[] annotations) {
        ArrayList<MediaType> l = new ArrayList<MediaType>();
        HashMap instanceCache = new HashMap();
        for (Map.Entry e : this.writeProviders.entrySet()) {
            MediaType mime = (MediaType)e.getKey();
            for (ObjectFactory pf : (List)e.getValue()) {
                Class<?> clazz = pf.getObjectModel().getObjectClass();
                MessageBodyWriter writer = (MessageBodyWriter)instanceCache.get(clazz);
                if (writer == null) {
                    writer = (MessageBodyWriter)pf.getInstance(ApplicationContextImpl.getCurrent());
                    instanceCache.put(clazz, writer);
                }
                if (!writer.isWriteable(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE)) continue;
                l.add(mime);
            }
        }
        Collections.sort(l, MediaTypeHelper.MEDIA_TYPE_COMPARATOR);
        return l;
    }

    protected <T> ContextResolver<T> doGetContextResolver(Class<T> contextType, MediaType mediaType) {
        MediaTypeMap<ObjectFactory<ProviderDescriptor>> pm = this.contextResolvers.get(contextType);
        ContextResolver<T> resolver = null;
        MediaTypeRange mrange = new MediaTypeRange(mediaType);
        if (pm != null) {
            while (mrange.hasNext() && resolver == null) {
                MediaType actual = mrange.next();
                resolver = this.doGetContextResolver(pm, contextType, actual);
            }
        }
        return resolver;
    }

    private <T> ContextResolver<T> doGetContextResolver(MediaTypeMap<ObjectFactory<ProviderDescriptor>> pm, Class<T> contextType, MediaType mediaType) {
        for (Map.Entry e : pm.entrySet()) {
            if (!mediaType.isCompatible((MediaType)e.getKey())) continue;
            return (ContextResolver)((ObjectFactory)e.getValue()).getInstance(ApplicationContextImpl.getCurrent());
        }
        return null;
    }

    protected <T extends Throwable> ExceptionMapper<T> doGetExceptionMapper(Class<T> type) {
        ObjectFactory<ProviderDescriptor> pf = this.exceptionMappers.get(type);
        if (pf != null) {
            return (ExceptionMapper)pf.getInstance(ApplicationContextImpl.getCurrent());
        }
        return null;
    }

    protected <T> MessageBodyReader<T> doGetMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeRange mrange = new MediaTypeRange(mediaType);
        HashMap instanceCache = new HashMap();
        while (mrange.hasNext()) {
            MediaType actual = mrange.next();
            for (ObjectFactory<ProviderDescriptor> pf : this.readProviders.getList(actual)) {
                Class<?> clazz = pf.getObjectModel().getObjectClass();
                MessageBodyReader reader = (MessageBodyReader)instanceCache.get(clazz);
                if (reader == null) {
                    reader = (MessageBodyReader)pf.getInstance(ApplicationContextImpl.getCurrent());
                    instanceCache.put(clazz, reader);
                }
                if (!reader.isReadable(type, genericType, annotations, actual)) continue;
                return reader;
            }
        }
        return null;
    }

    protected <T> MessageBodyWriter<T> doGetMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeRange mrange = new MediaTypeRange(mediaType);
        HashMap instanceCache = new HashMap();
        while (mrange.hasNext()) {
            MediaType actual = mrange.next();
            for (ObjectFactory<ProviderDescriptor> pf : this.writeProviders.getList(actual)) {
                Class<?> clazz = pf.getObjectModel().getObjectClass();
                MessageBodyWriter writer = (MessageBodyWriter)instanceCache.get(clazz);
                if (writer == null) {
                    writer = (MessageBodyWriter)pf.getInstance(ApplicationContextImpl.getCurrent());
                    instanceCache.put(clazz, writer);
                }
                if (!writer.isWriteable(type, genericType, annotations, actual)) continue;
                return writer;
            }
        }
        return null;
    }

    protected List<ObjectFactory<FilterDescriptor>> doGetMatchedFilters(String path, UriPatternMap<ObjectFactory<FilterDescriptor>> m) {
        ArrayList<ObjectFactory<FilterDescriptor>> l = new ArrayList<ObjectFactory<FilterDescriptor>>();
        ArrayList<String> capturingValues = new ArrayList<String>();
        for (Map.Entry e : m.entrySet()) {
            int len;
            UriPattern uriPattern = (UriPattern)e.getKey();
            if (uriPattern != null && (!uriPattern.match(path, capturingValues) || capturingValues.get((len = capturingValues.size()) - 1) != null && !"/".equals(capturingValues.get(len - 1)))) continue;
            l.addAll((Collection)e.getValue());
        }
        return l;
    }

    protected void init() {
        ByteEntityProvider baep = new ByteEntityProvider();
        this.addMessageBodyReader(baep);
        this.addMessageBodyWriter(baep);
        DataSourceEntityProvider dsep = new DataSourceEntityProvider();
        this.addMessageBodyReader(dsep);
        this.addMessageBodyWriter(dsep);
        DOMSourceEntityProvider domsep = new DOMSourceEntityProvider();
        this.addMessageBodyReader(domsep);
        this.addMessageBodyWriter(domsep);
        FileEntityProvider fep = new FileEntityProvider();
        this.addMessageBodyReader(fep);
        this.addMessageBodyWriter(fep);
        MultivaluedMapEntityProvider mvep = new MultivaluedMapEntityProvider();
        this.addMessageBodyReader(mvep);
        this.addMessageBodyWriter(mvep);
        InputStreamEntityProvider isep = new InputStreamEntityProvider();
        this.addMessageBodyReader(isep);
        this.addMessageBodyWriter(isep);
        ReaderEntityProvider rep = new ReaderEntityProvider();
        this.addMessageBodyReader(rep);
        this.addMessageBodyWriter(rep);
        SAXSourceEntityProvider saxep = new SAXSourceEntityProvider();
        this.addMessageBodyReader(saxep);
        this.addMessageBodyWriter(saxep);
        StreamSourceEntityProvider ssep = new StreamSourceEntityProvider();
        this.addMessageBodyReader(ssep);
        this.addMessageBodyWriter(ssep);
        StringEntityProvider sep = new StringEntityProvider();
        this.addMessageBodyReader(sep);
        this.addMessageBodyWriter(sep);
        StreamOutputEntityProvider soep = new StreamOutputEntityProvider();
        this.addMessageBodyReader(soep);
        this.addMessageBodyWriter(soep);
        JsonEntityProvider jsep = new JsonEntityProvider();
        this.addMessageBodyReader(jsep);
        this.addMessageBodyWriter(jsep);
        this.addMessageBodyReader(JAXBElementEntityProvider.class);
        this.addMessageBodyWriter(JAXBElementEntityProvider.class);
        this.addMessageBodyReader(JAXBObjectEntityProvider.class);
        this.addMessageBodyWriter(JAXBObjectEntityProvider.class);
        this.addMessageBodyReader(MultipartFormDataEntityProvider.class);
        this.addContextResolver(new JAXBContextResolver());
        this.addExceptionMapper(new DefaultExceptionMapper());
    }

    protected final class MediaTypeRange
    implements Iterator<MediaType> {
        private MediaType next;

        MediaTypeRange(MediaType type) {
            this.next = type == null ? MediaTypeHelper.DEFAULT_TYPE : type;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public MediaType next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            MediaType type = this.next;
            this.fetchNext();
            return type;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        void fetchNext() {
            MediaType mediaType = this.next;
            this.next = null;
            if (!mediaType.isWildcardType() && !mediaType.isWildcardSubtype()) {
                String type = mediaType.getType();
                String subType = mediaType.getSubtype();
                Matcher extMatcher = MediaTypeHelper.EXT_SUBTYPE_PATTERN.matcher(subType);
                if (extMatcher.matches()) {
                    String extSubtypePrefix = extMatcher.group(1);
                    String extSubtype = extMatcher.group(2);
                    this.next = "*".equals(extSubtypePrefix) ? new MediaType(type, "*") : new MediaType(type, "*+" + extSubtype);
                } else {
                    this.next = new MediaType(type, "*+" + subType);
                }
            } else if (!mediaType.isWildcardType() && mediaType.isWildcardSubtype()) {
                this.next = MediaTypeHelper.DEFAULT_TYPE;
            }
        }
    }
}

