/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import org.everrest.core.header.QualityValue;
import org.everrest.core.impl.ContainerRequest;
import org.everrest.core.impl.header.AcceptLanguage;
import org.everrest.core.impl.header.AcceptMediaType;
import org.everrest.core.impl.header.AcceptToken;
import org.everrest.core.impl.header.HeaderHelper;
import org.everrest.core.impl.header.Language;
import org.everrest.core.impl.header.Token;

public final class VariantsHandler {
    private static final CompatibleChecker<AcceptMediaType, MediaType> MEDIATYPE_CHECKER = new CompatibleChecker<AcceptMediaType, MediaType>(){

        @Override
        public MediaType getValue(Variant variant) {
            return variant.getMediaType();
        }

        @Override
        public boolean isCompatible(AcceptMediaType accept, MediaType fromVariant) {
            return accept.isCompatible(fromVariant);
        }
    };
    private static final CompatibleChecker<AcceptLanguage, Locale> LANGUAGE_CHECKER = new CompatibleChecker<AcceptLanguage, Locale>(){

        @Override
        public Locale getValue(Variant variant) {
            return variant.getLanguage();
        }

        @Override
        public boolean isCompatible(AcceptLanguage accept, Locale fromVariant) {
            return accept.isCompatible(new Language(fromVariant));
        }
    };
    private static final CompatibleChecker<AcceptToken, String> CHARSET_CHECKER = new CompatibleChecker<AcceptToken, String>(){

        @Override
        public String getValue(Variant variant) {
            MediaType m = variant.getMediaType();
            return m != null ? (String)m.getParameters().get("charset") : null;
        }

        @Override
        public boolean isCompatible(AcceptToken accept, String fromVariant) {
            return accept.isCompatible(new Token(fromVariant));
        }
    };
    private static final CompatibleChecker<AcceptToken, String> ENCODING_CHECKER = new CompatibleChecker<AcceptToken, String>(){

        @Override
        public String getValue(Variant variant) {
            return variant.getEncoding();
        }

        @Override
        public boolean isCompatible(AcceptToken accept, String fromVariant) {
            return accept.isCompatible(new Token(fromVariant));
        }
    };

    private VariantsHandler() {
    }

    public static Variant handleVariants(ContainerRequest r, List<Variant> variants) {
        List<AcceptMediaType> m = HeaderHelper.createAcceptedMediaTypeList(HeaderHelper.convertToString(r.getRequestHeader("Accept")));
        List<AcceptLanguage> l = HeaderHelper.createAcceptedLanguageList(HeaderHelper.convertToString(r.getRequestHeader("Accept-Language")));
        List<AcceptToken> c = HeaderHelper.createAcceptedCharsetList(HeaderHelper.convertToString(r.getRequestHeader("Accept-Charset")));
        List<AcceptToken> e = HeaderHelper.createAcceptedEncodingList(HeaderHelper.convertToString(r.getRequestHeader("Accept-Encoding")));
        ArrayList<Variant> v = new ArrayList<Variant>(variants.size());
        for (Variant a : variants) {
            v.add(a);
        }
        VariantsHandler.handleVariants(m, v, MEDIATYPE_CHECKER);
        VariantsHandler.handleVariants(l, v, LANGUAGE_CHECKER);
        VariantsHandler.handleVariants(c, v, CHARSET_CHECKER);
        VariantsHandler.handleVariants(e, v, ENCODING_CHECKER);
        return v.size() != 0 ? (Variant)v.get(0) : null;
    }

    private static <T extends QualityValue, V> void handleVariants(List<T> accept, List<Variant> variants, CompatibleChecker<T, V> ch) {
        ArrayList<Variant> tmp = new ArrayList<Variant>();
        for (QualityValue a : accept) {
            for (Variant v : variants) {
                V p = ch.getValue(v);
                if (p == null || !ch.isCompatible(a, p)) continue;
                tmp.add(v);
            }
        }
        for (Variant v : variants) {
            if (ch.getValue(v) != null) continue;
            tmp.add(v);
        }
        variants.clear();
        variants.addAll(tmp);
    }

    private static interface CompatibleChecker<T, V> {
        public V getValue(Variant var1);

        public boolean isCompatible(T var1, V var2);
    }
}

